// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkAnalytics.Models;

namespace Azure.ResourceManager.NetworkAnalytics
{
    /// <summary>
    /// A class representing the DataProductsCatalog data model.
    /// The data catalog resource.
    /// </summary>
    public partial class DataProductsCatalogData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProductsCatalogData"/>. </summary>
        public DataProductsCatalogData()
        {
            Publishers = new ChangeTrackingList<PublisherInformation>();
        }

        /// <summary> Initializes a new instance of <see cref="DataProductsCatalogData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> The data catalog provisioning state. </param>
        /// <param name="publishers"> The data product publisher information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProductsCatalogData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, NetworkAnalyticsProvisioningState? provisioningState, IList<PublisherInformation> publishers, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            Publishers = publishers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The data catalog provisioning state. </summary>
        public NetworkAnalyticsProvisioningState? ProvisioningState { get; }
        /// <summary> The data product publisher information. </summary>
        public IList<PublisherInformation> Publishers { get; }
    }
}
