// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.NetworkAnalytics.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmNetworkAnalyticsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="NetworkAnalytics.DataProductData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The managed service identities assigned to this resource. </param>
        /// <param name="resourceGuid"> The resource GUID property of the data product resource. </param>
        /// <param name="provisioningState"> Latest provisioning state  of data product. </param>
        /// <param name="publisher"> Data product publisher name. </param>
        /// <param name="product"> Product name of data product. </param>
        /// <param name="majorVersion"> Major version of data product. </param>
        /// <param name="owners"> List of name or email associated with data product resource deployment. </param>
        /// <param name="redundancy"> Flag to enable or disable redundancy for data product. </param>
        /// <param name="purviewAccount"> Purview account url for data product to connect to. </param>
        /// <param name="purviewCollection"> Purview collection url for data product to connect to. </param>
        /// <param name="privateLinksEnabled"> Flag to enable or disable private link for data product resource. </param>
        /// <param name="publicNetworkAccess"> Flag to enable or disable public access of data product resource. </param>
        /// <param name="customerManagedKeyEncryptionEnabled"> Flag to enable customer managed key encryption for data product. </param>
        /// <param name="customerEncryptionKey"> Customer managed encryption key details for data product. </param>
        /// <param name="networkacls"> Network rule set for data product. </param>
        /// <param name="managedResourceGroupConfiguration"> Managed resource group configuration. </param>
        /// <param name="availableMinorVersions"> List of available minor versions of the data product resource. </param>
        /// <param name="currentMinorVersion"> Current configured minor version of the data product resource. </param>
        /// <param name="documentation"> Documentation link for the data product based on definition file. </param>
        /// <param name="consumptionEndpoints"> Resource links which exposed to the customer to query the data. </param>
        /// <param name="keyVaultUri"> Key vault url. </param>
        /// <returns> A new <see cref="NetworkAnalytics.DataProductData"/> instance for mocking. </returns>
        public static DataProductData DataProductData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string resourceGuid = null, NetworkAnalyticsProvisioningState? provisioningState = null, string publisher = null, string product = null, string majorVersion = null, IEnumerable<string> owners = null, DataProductControlState? redundancy = null, string purviewAccount = null, string purviewCollection = null, DataProductControlState? privateLinksEnabled = null, DataProductControlState? publicNetworkAccess = null, DataProductControlState? customerManagedKeyEncryptionEnabled = null, EncryptionKeyDetails customerEncryptionKey = null, DataProductNetworkAcls networkacls = null, NetworkAnalyticsManagedResourceGroupConfiguration managedResourceGroupConfiguration = null, IEnumerable<string> availableMinorVersions = null, string currentMinorVersion = null, string documentation = null, ConsumptionEndpointsProperties consumptionEndpoints = null, Uri keyVaultUri = null)
        {
            tags ??= new Dictionary<string, string>();
            owners ??= new List<string>();
            availableMinorVersions ??= new List<string>();

            return new DataProductData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                resourceGuid,
                provisioningState,
                publisher,
                product,
                majorVersion,
                owners?.ToList(),
                redundancy,
                purviewAccount,
                purviewCollection,
                privateLinksEnabled,
                publicNetworkAccess,
                customerManagedKeyEncryptionEnabled,
                customerEncryptionKey,
                networkacls,
                managedResourceGroupConfiguration,
                availableMinorVersions?.ToList(),
                currentMinorVersion,
                documentation,
                consumptionEndpoints,
                keyVaultUri,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionEndpointsProperties"/>. </summary>
        /// <param name="ingestionUri"> Ingestion url to upload the data. </param>
        /// <param name="ingestionResourceId"> Resource Id of ingestion endpoint. </param>
        /// <param name="fileAccessUri"> Url to consume file type. </param>
        /// <param name="fileAccessResourceId"> Resource Id of file access endpoint. </param>
        /// <param name="queryUri"> Url to consume the processed data. </param>
        /// <param name="queryResourceId"> Resource Id of query endpoint. </param>
        /// <returns> A new <see cref="Models.ConsumptionEndpointsProperties"/> instance for mocking. </returns>
        public static ConsumptionEndpointsProperties ConsumptionEndpointsProperties(Uri ingestionUri = null, ResourceIdentifier ingestionResourceId = null, Uri fileAccessUri = null, ResourceIdentifier fileAccessResourceId = null, Uri queryUri = null, ResourceIdentifier queryResourceId = null)
        {
            return new ConsumptionEndpointsProperties(
                ingestionUri,
                ingestionResourceId,
                fileAccessUri,
                fileAccessResourceId,
                queryUri,
                queryResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="NetworkAnalytics.DataProductsCatalogData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> The data catalog provisioning state. </param>
        /// <param name="publishers"> The data product publisher information. </param>
        /// <returns> A new <see cref="NetworkAnalytics.DataProductsCatalogData"/> instance for mocking. </returns>
        public static DataProductsCatalogData DataProductsCatalogData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NetworkAnalyticsProvisioningState? provisioningState = null, IEnumerable<PublisherInformation> publishers = null)
        {
            publishers ??= new List<PublisherInformation>();

            return new DataProductsCatalogData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                publishers?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataProductDataType"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Latest provisioning state  of data product. </param>
        /// <param name="state"> State of data type. </param>
        /// <param name="stateReason"> Reason for the state of data type. </param>
        /// <param name="storageOutputRetention"> Field for storage output retention in days. </param>
        /// <param name="databaseCacheRetention"> Field for database cache retention in days. </param>
        /// <param name="databaseRetention"> Field for database data retention in days. </param>
        /// <param name="visualizationUri"> Url for data visualization. </param>
        /// <returns> A new <see cref="Models.DataProductDataType"/> instance for mocking. </returns>
        public static DataProductDataType DataProductDataType(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NetworkAnalyticsProvisioningState? provisioningState = null, DataProductDataTypeState? state = null, string stateReason = null, int? storageOutputRetention = null, int? databaseCacheRetention = null, int? databaseRetention = null, Uri visualizationUri = null)
        {
            return new DataProductDataType(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                state,
                stateReason,
                storageOutputRetention,
                databaseCacheRetention,
                databaseRetention,
                visualizationUri,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccountSasToken"/>. </summary>
        /// <param name="storageAccountSasToken"> Field to specify storage account sas token. </param>
        /// <returns> A new <see cref="Models.AccountSasToken"/> instance for mocking. </returns>
        public static AccountSasToken AccountSasToken(string storageAccountSasToken = null)
        {
            return new AccountSasToken(storageAccountSasToken, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoleAssignmentListResult"/>. </summary>
        /// <param name="count"> Count of role assignments. </param>
        /// <param name="roleAssignmentResponse"> list of role assignments. </param>
        /// <returns> A new <see cref="Models.RoleAssignmentListResult"/> instance for mocking. </returns>
        public static RoleAssignmentListResult RoleAssignmentListResult(int count = default, IEnumerable<RoleAssignmentDetail> roleAssignmentResponse = null)
        {
            roleAssignmentResponse ??= new List<RoleAssignmentDetail>();

            return new RoleAssignmentListResult(count, roleAssignmentResponse?.ToList(), serializedAdditionalRawData: null);
        }
    }
}
