// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkAnalytics.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.NetworkAnalytics.Samples
{
    public partial class Sample_DataProductResource
    {
        // DataProducts_ListBySubscription_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataProducts_DataProductsListBySubscriptionMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListBySubscription_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataProductResource item in subscriptionResource.GetDataProductsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataProductData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_ListBySubscription_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataProducts_DataProductsListBySubscriptionMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListBySubscription_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataProductResource item in subscriptionResource.GetDataProductsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataProductData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DataProductsGetMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            DataProductResource result = await dataProduct.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DataProducts_Get_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DataProductsGetMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            DataProductResource result = await dataProduct.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DataProducts_Update_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_DataProductsUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Update_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            DataProductPatch patch = new DataProductPatch()
            {
                Identity = new ManagedServiceIdentity("UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1")] = new UserAssignedIdentity(),
},
                },
                Tags =
{
["userSpecifiedKeyName"] = "userSpecifiedKeyValue",
},
                Owners =
{
"abc@micros.com","def@micros.com"
},
                PurviewAccount = "testpurview",
                PurviewCollection = "134567890",
                PrivateLinksEnabled = DataProductControlState.Disabled,
                CurrentMinorVersion = "1.0.1",
            };
            ArmOperation<DataProductResource> lro = await dataProduct.UpdateAsync(WaitUntil.Completed, patch);
            DataProductResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DataProducts_Update_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_DataProductsUpdateMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Update_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            DataProductPatch patch = new DataProductPatch();
            ArmOperation<DataProductResource> lro = await dataProduct.UpdateAsync(WaitUntil.Completed, patch);
            DataProductResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataProductData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DataProducts_Delete_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DataProductsDeleteMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Delete_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            await dataProduct.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_Delete_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DataProductsDeleteMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Delete_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            await dataProduct.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_AddUserRole_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AddUserRole_DataProductsAddUserRoleMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_AddUserRole_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_AddUserRole" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            RoleAssignmentCommonProperties body = new RoleAssignmentCommonProperties("00000000-0000-0000-0000-00000000000", "00000000-0000-0000-0000-00000000000", "UserName", new string[]
            {
"scope"
            }, "User", DataProductUserRole.Reader);
            RoleAssignmentDetail result = await dataProduct.AddUserRoleAsync(body);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DataProducts_AddUserRole_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AddUserRole_DataProductsAddUserRoleMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_AddUserRole_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_AddUserRole" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            RoleAssignmentCommonProperties body = new RoleAssignmentCommonProperties("00000000-0000-0000-0000-00000000000", "00000000-0000-0000-0000-00000000000", "userName", new string[]
            {
"scope"
            }, "User", DataProductUserRole.Reader);
            RoleAssignmentDetail result = await dataProduct.AddUserRoleAsync(body);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DataProducts_GenerateStorageAccountSasToken_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GenerateStorageAccountSasToken_DataProductsGenerateStorageAccountSasTokenMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_GenerateStorageAccountSasToken_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_GenerateStorageAccountSasToken" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            AccountSasContent content = new AccountSasContent(DateTimeOffset.Parse("2023-08-24T05:34:58.151Z"), DateTimeOffset.Parse("2023-08-24T05:34:58.151Z"), "1.1.1.1");
            AccountSasToken result = await dataProduct.GenerateStorageAccountSasTokenAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DataProducts_GenerateStorageAccountSasToken_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GenerateStorageAccountSasToken_DataProductsGenerateStorageAccountSasTokenMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_GenerateStorageAccountSasToken_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_GenerateStorageAccountSasToken" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            AccountSasContent content = new AccountSasContent(DateTimeOffset.Parse("2023-08-24T05:35:17.051Z"), DateTimeOffset.Parse("2023-08-24T05:35:17.051Z"), "1.1.1.1");
            AccountSasToken result = await dataProduct.GenerateStorageAccountSasTokenAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DataProducts_ListRolesAssignments_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRolesAssignments_DataProductsListRolesAssignmentsMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListRolesAssignments_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_ListRolesAssignments" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            BinaryData body = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
            {
            });
            RoleAssignmentListResult result = await dataProduct.GetRolesAssignmentsAsync(body);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DataProducts_ListRolesAssignments_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRolesAssignments_DataProductsListRolesAssignmentsMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListRolesAssignments_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_ListRolesAssignments" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            BinaryData body = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
            {
            });
            RoleAssignmentListResult result = await dataProduct.GetRolesAssignmentsAsync(body);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DataProducts_RemoveUserRole_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RemoveUserRole_DataProductsRemoveUserRoleMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RemoveUserRole_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_RemoveUserRole" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            RoleAssignmentDetail body = new RoleAssignmentDetail("00000000-0000-0000-0000-00000000000", "00000000-0000-0000-0000-00000000000", "UserName", new string[]
            {
"scope"
            }, "User", DataProductUserRole.Reader, "00000000-0000-0000-0000-00000000000");
            await dataProduct.RemoveUserRoleAsync(body);

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_RemoveUserRole_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RemoveUserRole_DataProductsRemoveUserRoleMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RemoveUserRole_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_RemoveUserRole" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            RoleAssignmentDetail body = new RoleAssignmentDetail("00000000-0000-0000-0000-00000000000", "00000000-0000-0000-0000-00000000000", "UserName", new string[]
            {
"scope"
            }, "User", DataProductUserRole.Reader, "00000000-0000-0000-0000-00000000000");
            await dataProduct.RemoveUserRoleAsync(body);

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_RotateKey_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RotateKey_DataProductsRotateKeyMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RotateKey_MaximumSet_Gen.json
            // this example is just showing the usage of "DataProducts_RotateKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            NetworkAnalyticsKeyVaultContent content = new NetworkAnalyticsKeyVaultContent(new Uri("https://myKeyVault.vault.azure.net"));
            await dataProduct.RotateKeyAsync(content);

            Console.WriteLine($"Succeeded");
        }

        // DataProducts_RotateKey_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RotateKey_DataProductsRotateKeyMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RotateKey_MinimumSet_Gen.json
            // this example is just showing the usage of "DataProducts_RotateKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation
            NetworkAnalyticsKeyVaultContent content = new NetworkAnalyticsKeyVaultContent(new Uri("https://myKeyVault.vault.azure.net"));
            await dataProduct.RotateKeyAsync(content);

            Console.WriteLine($"Succeeded");
        }

        // DataTypes_ListByDataProduct_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataTypes_DataTypesListByDataProductMaximumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_ListByDataProduct_MaximumSet_Gen.json
            // this example is just showing the usage of "DataTypes_ListByDataProduct" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataProductDataType item in dataProduct.GetDataTypesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // DataTypes_ListByDataProduct_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataTypes_DataTypesListByDataProductMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen()
        {
            // Generated from example definition: specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_ListByDataProduct_MinimumSet_Gen.json
            // this example is just showing the usage of "DataTypes_ListByDataProduct" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataProductResource created on azure
            // for more information of creating DataProductResource, please refer to the document of DataProductResource
            string subscriptionId = "00000000-0000-0000-0000-00000000000";
            string resourceGroupName = "aoiresourceGroupName";
            string dataProductName = "dataproduct01";
            ResourceIdentifier dataProductResourceId = DataProductResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataProductName);
            DataProductResource dataProduct = client.GetDataProductResource(dataProductResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataProductDataType item in dataProduct.GetDataTypesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
