// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the VpnSiteLinkConnection data model.
    /// VpnSiteLinkConnection Resource.
    /// </summary>
    public partial class VpnSiteLinkConnectionData : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="VpnSiteLinkConnectionData"/>. </summary>
        public VpnSiteLinkConnectionData()
        {
            VpnGatewayCustomBgpAddresses = new ChangeTrackingList<GatewayCustomBgpIPAddressIPConfiguration>();
            IPsecPolicies = new ChangeTrackingList<IPsecPolicy>();
            IngressNatRules = new ChangeTrackingList<WritableSubResource>();
            EgressNatRules = new ChangeTrackingList<WritableSubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="VpnSiteLinkConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vpnSiteLink"> Id of the connected vpn site link. </param>
        /// <param name="routingWeight"> Routing weight for vpn connection. </param>
        /// <param name="vpnLinkConnectionMode"> Vpn link connection mode. </param>
        /// <param name="connectionStatus"> The connection status. </param>
        /// <param name="vpnConnectionProtocolType"> Connection protocol used for this connection. </param>
        /// <param name="ingressBytesTransferred"> Ingress bytes transferred. </param>
        /// <param name="egressBytesTransferred"> Egress bytes transferred. </param>
        /// <param name="connectionBandwidth"> Expected bandwidth in MBPS. </param>
        /// <param name="sharedKey"> SharedKey for the vpn connection. </param>
        /// <param name="enableBgp"> EnableBgp flag. </param>
        /// <param name="vpnGatewayCustomBgpAddresses"> vpnGatewayCustomBgpAddresses used by this connection. </param>
        /// <param name="usePolicyBasedTrafficSelectors"> Enable policy-based traffic selectors. </param>
        /// <param name="ipsecPolicies"> The IPSec Policies to be considered by this connection. </param>
        /// <param name="enableRateLimiting"> EnableBgp flag. </param>
        /// <param name="useLocalAzureIPAddress"> Use local azure ip to initiate connection. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN site link connection resource. </param>
        /// <param name="ingressNatRules"> List of ingress NatRules. </param>
        /// <param name="egressNatRules"> List of egress NatRules. </param>
        /// <param name="dpdTimeoutSeconds"> Dead Peer Detection timeout in seconds for VpnLink connection. </param>
        internal VpnSiteLinkConnectionData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, WritableSubResource vpnSiteLink, int? routingWeight, VpnLinkConnectionMode? vpnLinkConnectionMode, VpnConnectionStatus? connectionStatus, VirtualNetworkGatewayConnectionProtocol? vpnConnectionProtocolType, long? ingressBytesTransferred, long? egressBytesTransferred, int? connectionBandwidth, string sharedKey, bool? enableBgp, IList<GatewayCustomBgpIPAddressIPConfiguration> vpnGatewayCustomBgpAddresses, bool? usePolicyBasedTrafficSelectors, IList<IPsecPolicy> ipsecPolicies, bool? enableRateLimiting, bool? useLocalAzureIPAddress, NetworkProvisioningState? provisioningState, IList<WritableSubResource> ingressNatRules, IList<WritableSubResource> egressNatRules, int? dpdTimeoutSeconds) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            VpnSiteLink = vpnSiteLink;
            RoutingWeight = routingWeight;
            VpnLinkConnectionMode = vpnLinkConnectionMode;
            ConnectionStatus = connectionStatus;
            VpnConnectionProtocolType = vpnConnectionProtocolType;
            IngressBytesTransferred = ingressBytesTransferred;
            EgressBytesTransferred = egressBytesTransferred;
            ConnectionBandwidth = connectionBandwidth;
            SharedKey = sharedKey;
            EnableBgp = enableBgp;
            VpnGatewayCustomBgpAddresses = vpnGatewayCustomBgpAddresses;
            UsePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
            IPsecPolicies = ipsecPolicies;
            EnableRateLimiting = enableRateLimiting;
            UseLocalAzureIPAddress = useLocalAzureIPAddress;
            ProvisioningState = provisioningState;
            IngressNatRules = ingressNatRules;
            EgressNatRules = egressNatRules;
            DpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Id of the connected vpn site link. </summary>
        internal WritableSubResource VpnSiteLink { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier VpnSiteLinkId
        {
            get => VpnSiteLink is null ? default : VpnSiteLink.Id;
            set
            {
                if (VpnSiteLink is null)
                    VpnSiteLink = new WritableSubResource();
                VpnSiteLink.Id = value;
            }
        }

        /// <summary> Routing weight for vpn connection. </summary>
        public int? RoutingWeight { get; set; }
        /// <summary> Vpn link connection mode. </summary>
        public VpnLinkConnectionMode? VpnLinkConnectionMode { get; set; }
        /// <summary> The connection status. </summary>
        public VpnConnectionStatus? ConnectionStatus { get; }
        /// <summary> Connection protocol used for this connection. </summary>
        public VirtualNetworkGatewayConnectionProtocol? VpnConnectionProtocolType { get; set; }
        /// <summary> Ingress bytes transferred. </summary>
        public long? IngressBytesTransferred { get; }
        /// <summary> Egress bytes transferred. </summary>
        public long? EgressBytesTransferred { get; }
        /// <summary> Expected bandwidth in MBPS. </summary>
        public int? ConnectionBandwidth { get; set; }
        /// <summary> SharedKey for the vpn connection. </summary>
        public string SharedKey { get; set; }
        /// <summary> EnableBgp flag. </summary>
        public bool? EnableBgp { get; set; }
        /// <summary> vpnGatewayCustomBgpAddresses used by this connection. </summary>
        public IList<GatewayCustomBgpIPAddressIPConfiguration> VpnGatewayCustomBgpAddresses { get; }
        /// <summary> Enable policy-based traffic selectors. </summary>
        public bool? UsePolicyBasedTrafficSelectors { get; set; }
        /// <summary> The IPSec Policies to be considered by this connection. </summary>
        public IList<IPsecPolicy> IPsecPolicies { get; }
        /// <summary> EnableBgp flag. </summary>
        public bool? EnableRateLimiting { get; set; }
        /// <summary> Use local azure ip to initiate connection. </summary>
        public bool? UseLocalAzureIPAddress { get; set; }
        /// <summary> The provisioning state of the VPN site link connection resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> List of ingress NatRules. </summary>
        public IList<WritableSubResource> IngressNatRules { get; }
        /// <summary> List of egress NatRules. </summary>
        public IList<WritableSubResource> EgressNatRules { get; }
        /// <summary> Dead Peer Detection timeout in seconds for VpnLink connection. </summary>
        public int? DpdTimeoutSeconds { get; set; }
    }
}
