// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    public partial class VirtualNetworkPeeringData : IUtf8JsonSerializable, IJsonModel<VirtualNetworkPeeringData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VirtualNetworkPeeringData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VirtualNetworkPeeringData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualNetworkPeeringData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VirtualNetworkPeeringData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AllowVirtualNetworkAccess))
            {
                writer.WritePropertyName("allowVirtualNetworkAccess"u8);
                writer.WriteBooleanValue(AllowVirtualNetworkAccess.Value);
            }
            if (Optional.IsDefined(AllowForwardedTraffic))
            {
                writer.WritePropertyName("allowForwardedTraffic"u8);
                writer.WriteBooleanValue(AllowForwardedTraffic.Value);
            }
            if (Optional.IsDefined(AllowGatewayTransit))
            {
                writer.WritePropertyName("allowGatewayTransit"u8);
                writer.WriteBooleanValue(AllowGatewayTransit.Value);
            }
            if (Optional.IsDefined(UseRemoteGateways))
            {
                writer.WritePropertyName("useRemoteGateways"u8);
                writer.WriteBooleanValue(UseRemoteGateways.Value);
            }
            if (Optional.IsDefined(RemoteVirtualNetwork))
            {
                writer.WritePropertyName("remoteVirtualNetwork"u8);
                JsonSerializer.Serialize(writer, RemoteVirtualNetwork);
            }
            if (Optional.IsDefined(LocalAddressSpace))
            {
                writer.WritePropertyName("localAddressSpace"u8);
                writer.WriteObjectValue(LocalAddressSpace, options);
            }
            if (Optional.IsDefined(LocalVirtualNetworkAddressSpace))
            {
                writer.WritePropertyName("localVirtualNetworkAddressSpace"u8);
                writer.WriteObjectValue(LocalVirtualNetworkAddressSpace, options);
            }
            if (Optional.IsDefined(RemoteAddressSpace))
            {
                writer.WritePropertyName("remoteAddressSpace"u8);
                writer.WriteObjectValue(RemoteAddressSpace, options);
            }
            if (Optional.IsDefined(RemoteVirtualNetworkAddressSpace))
            {
                writer.WritePropertyName("remoteVirtualNetworkAddressSpace"u8);
                writer.WriteObjectValue(RemoteVirtualNetworkAddressSpace, options);
            }
            if (Optional.IsDefined(RemoteBgpCommunities))
            {
                writer.WritePropertyName("remoteBgpCommunities"u8);
                writer.WriteObjectValue(RemoteBgpCommunities, options);
            }
            if (options.Format != "W" && Optional.IsDefined(RemoteVirtualNetworkEncryption))
            {
                writer.WritePropertyName("remoteVirtualNetworkEncryption"u8);
                writer.WriteObjectValue(RemoteVirtualNetworkEncryption, options);
            }
            if (Optional.IsDefined(PeeringState))
            {
                writer.WritePropertyName("peeringState"u8);
                writer.WriteStringValue(PeeringState.Value.ToString());
            }
            if (Optional.IsDefined(PeeringSyncLevel))
            {
                writer.WritePropertyName("peeringSyncLevel"u8);
                writer.WriteStringValue(PeeringSyncLevel.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(DoNotVerifyRemoteGateways))
            {
                writer.WritePropertyName("doNotVerifyRemoteGateways"u8);
                writer.WriteBooleanValue(DoNotVerifyRemoteGateways.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGuid))
            {
                writer.WritePropertyName("resourceGuid"u8);
                writer.WriteStringValue(ResourceGuid.Value);
            }
            if (Optional.IsDefined(AreCompleteVnetsPeered))
            {
                writer.WritePropertyName("peerCompleteVnets"u8);
                writer.WriteBooleanValue(AreCompleteVnetsPeered.Value);
            }
            if (Optional.IsDefined(EnableOnlyIPv6Peering))
            {
                writer.WritePropertyName("enableOnlyIPv6Peering"u8);
                writer.WriteBooleanValue(EnableOnlyIPv6Peering.Value);
            }
            if (Optional.IsCollectionDefined(LocalSubnetNames))
            {
                writer.WritePropertyName("localSubnetNames"u8);
                writer.WriteStartArray();
                foreach (var item in LocalSubnetNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RemoteSubnetNames))
            {
                writer.WritePropertyName("remoteSubnetNames"u8);
                writer.WriteStartArray();
                foreach (var item in RemoteSubnetNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        VirtualNetworkPeeringData IJsonModel<VirtualNetworkPeeringData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualNetworkPeeringData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VirtualNetworkPeeringData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVirtualNetworkPeeringData(document.RootElement, options);
        }

        internal static VirtualNetworkPeeringData DeserializeVirtualNetworkPeeringData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType? type = default;
            bool? allowVirtualNetworkAccess = default;
            bool? allowForwardedTraffic = default;
            bool? allowGatewayTransit = default;
            bool? useRemoteGateways = default;
            WritableSubResource remoteVirtualNetwork = default;
            AddressSpace localAddressSpace = default;
            AddressSpace localVirtualNetworkAddressSpace = default;
            AddressSpace remoteAddressSpace = default;
            AddressSpace remoteVirtualNetworkAddressSpace = default;
            VirtualNetworkBgpCommunities remoteBgpCommunities = default;
            VirtualNetworkEncryption remoteVirtualNetworkEncryption = default;
            VirtualNetworkPeeringState? peeringState = default;
            VirtualNetworkPeeringLevel? peeringSyncLevel = default;
            NetworkProvisioningState? provisioningState = default;
            bool? doNotVerifyRemoteGateways = default;
            Guid? resourceGuid = default;
            bool? peerCompleteVnets = default;
            bool? enableOnlyIPv6Peering = default;
            IList<string> localSubnetNames = default;
            IList<string> remoteSubnetNames = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("allowVirtualNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allowVirtualNetworkAccess = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("allowForwardedTraffic"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allowForwardedTraffic = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("allowGatewayTransit"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allowGatewayTransit = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("useRemoteGateways"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            useRemoteGateways = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("remoteVirtualNetwork"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remoteVirtualNetwork = JsonSerializer.Deserialize<WritableSubResource>(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("localAddressSpace"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            localAddressSpace = AddressSpace.DeserializeAddressSpace(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("localVirtualNetworkAddressSpace"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            localVirtualNetworkAddressSpace = AddressSpace.DeserializeAddressSpace(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("remoteAddressSpace"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remoteAddressSpace = AddressSpace.DeserializeAddressSpace(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("remoteVirtualNetworkAddressSpace"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remoteVirtualNetworkAddressSpace = AddressSpace.DeserializeAddressSpace(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("remoteBgpCommunities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remoteBgpCommunities = VirtualNetworkBgpCommunities.DeserializeVirtualNetworkBgpCommunities(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("remoteVirtualNetworkEncryption"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remoteVirtualNetworkEncryption = VirtualNetworkEncryption.DeserializeVirtualNetworkEncryption(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("peeringState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            peeringState = new VirtualNetworkPeeringState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("peeringSyncLevel"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            peeringSyncLevel = new VirtualNetworkPeeringLevel(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("doNotVerifyRemoteGateways"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            doNotVerifyRemoteGateways = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("resourceGuid"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceGuid = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("peerCompleteVnets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            peerCompleteVnets = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableOnlyIPv6Peering"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableOnlyIPv6Peering = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("localSubnetNames"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            localSubnetNames = array;
                            continue;
                        }
                        if (property0.NameEquals("remoteSubnetNames"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            remoteSubnetNames = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VirtualNetworkPeeringData(
                id,
                name,
                type,
                serializedAdditionalRawData,
                etag,
                allowVirtualNetworkAccess,
                allowForwardedTraffic,
                allowGatewayTransit,
                useRemoteGateways,
                remoteVirtualNetwork,
                localAddressSpace,
                localVirtualNetworkAddressSpace,
                remoteAddressSpace,
                remoteVirtualNetworkAddressSpace,
                remoteBgpCommunities,
                remoteVirtualNetworkEncryption,
                peeringState,
                peeringSyncLevel,
                provisioningState,
                doNotVerifyRemoteGateways,
                resourceGuid,
                peerCompleteVnets,
                enableOnlyIPv6Peering,
                localSubnetNames ?? new ChangeTrackingList<string>(),
                remoteSubnetNames ?? new ChangeTrackingList<string>());
        }

        BinaryData IPersistableModel<VirtualNetworkPeeringData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualNetworkPeeringData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VirtualNetworkPeeringData)} does not support writing '{options.Format}' format.");
            }
        }

        VirtualNetworkPeeringData IPersistableModel<VirtualNetworkPeeringData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualNetworkPeeringData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVirtualNetworkPeeringData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VirtualNetworkPeeringData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VirtualNetworkPeeringData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
