// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    public partial class SubnetData : IUtf8JsonSerializable, IJsonModel<SubnetData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SubnetData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SubnetData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubnetData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SubnetData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AddressPrefix))
            {
                writer.WritePropertyName("addressPrefix"u8);
                writer.WriteStringValue(AddressPrefix);
            }
            if (Optional.IsCollectionDefined(AddressPrefixes))
            {
                writer.WritePropertyName("addressPrefixes"u8);
                writer.WriteStartArray();
                foreach (var item in AddressPrefixes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(NetworkSecurityGroup))
            {
                writer.WritePropertyName("networkSecurityGroup"u8);
                writer.WriteObjectValue(NetworkSecurityGroup, options);
            }
            if (Optional.IsDefined(RouteTable))
            {
                writer.WritePropertyName("routeTable"u8);
                writer.WriteObjectValue(RouteTable, options);
            }
            if (Optional.IsDefined(NatGateway))
            {
                writer.WritePropertyName("natGateway"u8);
                JsonSerializer.Serialize(writer, NatGateway);
            }
            if (Optional.IsCollectionDefined(ServiceEndpoints))
            {
                writer.WritePropertyName("serviceEndpoints"u8);
                writer.WriteStartArray();
                foreach (var item in ServiceEndpoints)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ServiceEndpointPolicies))
            {
                writer.WritePropertyName("serviceEndpointPolicies"u8);
                writer.WriteStartArray();
                foreach (var item in ServiceEndpointPolicies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpoints))
            {
                writer.WritePropertyName("privateEndpoints"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpoints)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(IPConfigurations))
            {
                writer.WritePropertyName("ipConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in IPConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(IPConfigurationProfiles))
            {
                writer.WritePropertyName("ipConfigurationProfiles"u8);
                writer.WriteStartArray();
                foreach (var item in IPConfigurationProfiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IPAllocations))
            {
                writer.WritePropertyName("ipAllocations"u8);
                writer.WriteStartArray();
                foreach (var item in IPAllocations)
                {
                    JsonSerializer.Serialize(writer, item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ResourceNavigationLinks))
            {
                writer.WritePropertyName("resourceNavigationLinks"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceNavigationLinks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ServiceAssociationLinks))
            {
                writer.WritePropertyName("serviceAssociationLinks"u8);
                writer.WriteStartArray();
                foreach (var item in ServiceAssociationLinks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Delegations))
            {
                writer.WritePropertyName("delegations"u8);
                writer.WriteStartArray();
                foreach (var item in Delegations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Purpose))
            {
                writer.WritePropertyName("purpose"u8);
                writer.WriteStringValue(Purpose);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(PrivateEndpointNetworkPolicy))
            {
                writer.WritePropertyName("privateEndpointNetworkPolicies"u8);
                writer.WriteStringValue(PrivateEndpointNetworkPolicy.Value.ToString());
            }
            if (Optional.IsDefined(PrivateLinkServiceNetworkPolicy))
            {
                writer.WritePropertyName("privateLinkServiceNetworkPolicies"u8);
                writer.WriteStringValue(PrivateLinkServiceNetworkPolicy.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ApplicationGatewayIPConfigurations))
            {
                writer.WritePropertyName("applicationGatewayIPConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in ApplicationGatewayIPConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SharingScope))
            {
                writer.WritePropertyName("sharingScope"u8);
                writer.WriteStringValue(SharingScope.Value.ToString());
            }
            if (Optional.IsDefined(DefaultOutboundAccess))
            {
                writer.WritePropertyName("defaultOutboundAccess"u8);
                writer.WriteBooleanValue(DefaultOutboundAccess.Value);
            }
            writer.WriteEndObject();
        }

        SubnetData IJsonModel<SubnetData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubnetData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SubnetData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSubnetData(document.RootElement, options);
        }

        internal static SubnetData DeserializeSubnetData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType? type = default;
            string addressPrefix = default;
            IList<string> addressPrefixes = default;
            NetworkSecurityGroupData networkSecurityGroup = default;
            RouteTableData routeTable = default;
            WritableSubResource natGateway = default;
            IList<ServiceEndpointProperties> serviceEndpoints = default;
            IList<ServiceEndpointPolicyData> serviceEndpointPolicies = default;
            IReadOnlyList<PrivateEndpointData> privateEndpoints = default;
            IReadOnlyList<NetworkIPConfiguration> ipConfigurations = default;
            IReadOnlyList<NetworkIPConfigurationProfile> ipConfigurationProfiles = default;
            IList<WritableSubResource> ipAllocations = default;
            IReadOnlyList<ResourceNavigationLink> resourceNavigationLinks = default;
            IReadOnlyList<ServiceAssociationLink> serviceAssociationLinks = default;
            IList<ServiceDelegation> delegations = default;
            string purpose = default;
            NetworkProvisioningState? provisioningState = default;
            VirtualNetworkPrivateEndpointNetworkPolicy? privateEndpointNetworkPolicies = default;
            VirtualNetworkPrivateLinkServiceNetworkPolicy? privateLinkServiceNetworkPolicies = default;
            IList<ApplicationGatewayIPConfiguration> applicationGatewayIPConfigurations = default;
            SharingScope? sharingScope = default;
            bool? defaultOutboundAccess = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("addressPrefix"u8))
                        {
                            addressPrefix = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("addressPrefixes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            addressPrefixes = array;
                            continue;
                        }
                        if (property0.NameEquals("networkSecurityGroup"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            networkSecurityGroup = NetworkSecurityGroupData.DeserializeNetworkSecurityGroupData(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("routeTable"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            routeTable = RouteTableData.DeserializeRouteTableData(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("natGateway"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            natGateway = JsonSerializer.Deserialize<WritableSubResource>(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("serviceEndpoints"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ServiceEndpointProperties> array = new List<ServiceEndpointProperties>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ServiceEndpointProperties.DeserializeServiceEndpointProperties(item, options));
                            }
                            serviceEndpoints = array;
                            continue;
                        }
                        if (property0.NameEquals("serviceEndpointPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ServiceEndpointPolicyData> array = new List<ServiceEndpointPolicyData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ServiceEndpointPolicyData.DeserializeServiceEndpointPolicyData(item, options));
                            }
                            serviceEndpointPolicies = array;
                            continue;
                        }
                        if (property0.NameEquals("privateEndpoints"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PrivateEndpointData> array = new List<PrivateEndpointData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PrivateEndpointData.DeserializePrivateEndpointData(item, options));
                            }
                            privateEndpoints = array;
                            continue;
                        }
                        if (property0.NameEquals("ipConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NetworkIPConfiguration> array = new List<NetworkIPConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NetworkIPConfiguration.DeserializeNetworkIPConfiguration(item, options));
                            }
                            ipConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("ipConfigurationProfiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NetworkIPConfigurationProfile> array = new List<NetworkIPConfigurationProfile>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NetworkIPConfigurationProfile.DeserializeNetworkIPConfigurationProfile(item, options));
                            }
                            ipConfigurationProfiles = array;
                            continue;
                        }
                        if (property0.NameEquals("ipAllocations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<WritableSubResource> array = new List<WritableSubResource>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(JsonSerializer.Deserialize<WritableSubResource>(item.GetRawText()));
                            }
                            ipAllocations = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceNavigationLinks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceNavigationLink> array = new List<ResourceNavigationLink>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ResourceNavigationLink.DeserializeResourceNavigationLink(item, options));
                            }
                            resourceNavigationLinks = array;
                            continue;
                        }
                        if (property0.NameEquals("serviceAssociationLinks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ServiceAssociationLink> array = new List<ServiceAssociationLink>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ServiceAssociationLink.DeserializeServiceAssociationLink(item, options));
                            }
                            serviceAssociationLinks = array;
                            continue;
                        }
                        if (property0.NameEquals("delegations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ServiceDelegation> array = new List<ServiceDelegation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ServiceDelegation.DeserializeServiceDelegation(item, options));
                            }
                            delegations = array;
                            continue;
                        }
                        if (property0.NameEquals("purpose"u8))
                        {
                            purpose = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointNetworkPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            privateEndpointNetworkPolicies = new VirtualNetworkPrivateEndpointNetworkPolicy(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("privateLinkServiceNetworkPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            privateLinkServiceNetworkPolicies = new VirtualNetworkPrivateLinkServiceNetworkPolicy(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("applicationGatewayIPConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayIPConfiguration> array = new List<ApplicationGatewayIPConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayIPConfiguration.DeserializeApplicationGatewayIPConfiguration(item, options));
                            }
                            applicationGatewayIPConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("sharingScope"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sharingScope = new SharingScope(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("defaultOutboundAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            defaultOutboundAccess = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SubnetData(
                id,
                name,
                type,
                serializedAdditionalRawData,
                etag,
                addressPrefix,
                addressPrefixes ?? new ChangeTrackingList<string>(),
                networkSecurityGroup,
                routeTable,
                natGateway,
                serviceEndpoints ?? new ChangeTrackingList<ServiceEndpointProperties>(),
                serviceEndpointPolicies ?? new ChangeTrackingList<ServiceEndpointPolicyData>(),
                privateEndpoints ?? new ChangeTrackingList<PrivateEndpointData>(),
                ipConfigurations ?? new ChangeTrackingList<NetworkIPConfiguration>(),
                ipConfigurationProfiles ?? new ChangeTrackingList<NetworkIPConfigurationProfile>(),
                ipAllocations ?? new ChangeTrackingList<WritableSubResource>(),
                resourceNavigationLinks ?? new ChangeTrackingList<ResourceNavigationLink>(),
                serviceAssociationLinks ?? new ChangeTrackingList<ServiceAssociationLink>(),
                delegations ?? new ChangeTrackingList<ServiceDelegation>(),
                purpose,
                provisioningState,
                privateEndpointNetworkPolicies,
                privateLinkServiceNetworkPolicies,
                applicationGatewayIPConfigurations ?? new ChangeTrackingList<ApplicationGatewayIPConfiguration>(),
                sharingScope,
                defaultOutboundAccess);
        }

        BinaryData IPersistableModel<SubnetData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubnetData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SubnetData)} does not support writing '{options.Format}' format.");
            }
        }

        SubnetData IPersistableModel<SubnetData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubnetData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSubnetData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SubnetData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SubnetData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
