// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the SecurityPartnerProvider data model.
    /// Security Partner Provider resource.
    /// </summary>
    public partial class SecurityPartnerProviderData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="SecurityPartnerProviderData"/>. </summary>
        public SecurityPartnerProviderData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityPartnerProviderData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the Security Partner Provider resource. </param>
        /// <param name="securityProviderName"> The security provider name. </param>
        /// <param name="connectionStatus"> The connection status with the Security Partner Provider. </param>
        /// <param name="virtualHub"> The virtualHub to which the Security Partner Provider belongs. </param>
        internal SecurityPartnerProviderData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, NetworkProvisioningState? provisioningState, SecurityProviderName? securityProviderName, SecurityPartnerProviderConnectionStatus? connectionStatus, WritableSubResource virtualHub) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            ETag = etag;
            ProvisioningState = provisioningState;
            SecurityProviderName = securityProviderName;
            ConnectionStatus = connectionStatus;
            VirtualHub = virtualHub;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The provisioning state of the Security Partner Provider resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> The security provider name. </summary>
        public SecurityProviderName? SecurityProviderName { get; set; }
        /// <summary> The connection status with the Security Partner Provider. </summary>
        public SecurityPartnerProviderConnectionStatus? ConnectionStatus { get; }
        /// <summary> The virtualHub to which the Security Partner Provider belongs. </summary>
        internal WritableSubResource VirtualHub { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier VirtualHubId
        {
            get => VirtualHub is null ? default : VirtualHub.Id;
            set
            {
                if (VirtualHub is null)
                    VirtualHub = new WritableSubResource();
                VirtualHub.Id = value;
            }
        }
    }
}
