// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the RouteFilter data model.
    /// Route Filter Resource.
    /// </summary>
    public partial class RouteFilterData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="RouteFilterData"/>. </summary>
        public RouteFilterData()
        {
            Rules = new ChangeTrackingList<RouteFilterRuleData>();
            Peerings = new ChangeTrackingList<ExpressRouteCircuitPeeringData>();
            IPv6Peerings = new ChangeTrackingList<ExpressRouteCircuitPeeringData>();
        }

        /// <summary> Initializes a new instance of <see cref="RouteFilterData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="rules"> Collection of RouteFilterRules contained within a route filter. </param>
        /// <param name="peerings"> A collection of references to express route circuit peerings. </param>
        /// <param name="ipv6Peerings"> A collection of references to express route circuit ipv6 peerings. </param>
        /// <param name="provisioningState"> The provisioning state of the route filter resource. </param>
        internal RouteFilterData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, IList<RouteFilterRuleData> rules, IReadOnlyList<ExpressRouteCircuitPeeringData> peerings, IReadOnlyList<ExpressRouteCircuitPeeringData> ipv6Peerings, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            ETag = etag;
            Rules = rules;
            Peerings = peerings;
            IPv6Peerings = ipv6Peerings;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Collection of RouteFilterRules contained within a route filter. </summary>
        public IList<RouteFilterRuleData> Rules { get; }
        /// <summary> A collection of references to express route circuit peerings. </summary>
        public IReadOnlyList<ExpressRouteCircuitPeeringData> Peerings { get; }
        /// <summary> A collection of references to express route circuit ipv6 peerings. </summary>
        public IReadOnlyList<ExpressRouteCircuitPeeringData> IPv6Peerings { get; }
        /// <summary> The provisioning state of the route filter resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
