// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the Probe data model.
    /// A load balancer probe.
    /// </summary>
    public partial class ProbeData : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="ProbeData"/>. </summary>
        public ProbeData()
        {
            LoadBalancingRules = new ChangeTrackingList<WritableSubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="ProbeData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadBalancingRules"> The load balancer rules that use this probe. </param>
        /// <param name="protocol"> The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. </param>
        /// <param name="port"> The port for communicating the probe. Possible values range from 1 to 65535, inclusive. </param>
        /// <param name="intervalInSeconds"> The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5. </param>
        /// <param name="noHealthyBackendsBehavior"> Determines how new connections are handled by the load balancer when all backend instances are probed down. </param>
        /// <param name="numberOfProbes"> The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. </param>
        /// <param name="probeThreshold"> The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation. </param>
        /// <param name="requestPath"> The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value. </param>
        /// <param name="provisioningState"> The provisioning state of the probe resource. </param>
        internal ProbeData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, IReadOnlyList<WritableSubResource> loadBalancingRules, ProbeProtocol? protocol, int? port, int? intervalInSeconds, ProbeNoHealthyBackendsBehavior? noHealthyBackendsBehavior, int? numberOfProbes, int? probeThreshold, string requestPath, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            LoadBalancingRules = loadBalancingRules;
            Protocol = protocol;
            Port = port;
            IntervalInSeconds = intervalInSeconds;
            NoHealthyBackendsBehavior = noHealthyBackendsBehavior;
            NumberOfProbes = numberOfProbes;
            ProbeThreshold = probeThreshold;
            RequestPath = requestPath;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The load balancer rules that use this probe. </summary>
        public IReadOnlyList<WritableSubResource> LoadBalancingRules { get; }
        /// <summary> The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. </summary>
        public ProbeProtocol? Protocol { get; set; }
        /// <summary> The port for communicating the probe. Possible values range from 1 to 65535, inclusive. </summary>
        public int? Port { get; set; }
        /// <summary> The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5. </summary>
        public int? IntervalInSeconds { get; set; }
        /// <summary> Determines how new connections are handled by the load balancer when all backend instances are probed down. </summary>
        public ProbeNoHealthyBackendsBehavior? NoHealthyBackendsBehavior { get; set; }
        /// <summary> The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. </summary>
        public int? NumberOfProbes { get; set; }
        /// <summary> The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation. </summary>
        public int? ProbeThreshold { get; set; }
        /// <summary> The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value. </summary>
        public string RequestPath { get; set; }
        /// <summary> The provisioning state of the probe resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
