// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the PrivateLinkService data model.
    /// Private link service resource.
    /// </summary>
    public partial class PrivateLinkServiceData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="PrivateLinkServiceData"/>. </summary>
        public PrivateLinkServiceData()
        {
            LoadBalancerFrontendIPConfigurations = new ChangeTrackingList<FrontendIPConfigurationData>();
            IPConfigurations = new ChangeTrackingList<PrivateLinkServiceIPConfiguration>();
            NetworkInterfaces = new ChangeTrackingList<NetworkInterfaceData>();
            PrivateEndpointConnections = new ChangeTrackingList<NetworkPrivateEndpointConnectionData>();
            Fqdns = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="PrivateLinkServiceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="extendedLocation"> The extended location of the load balancer. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadBalancerFrontendIPConfigurations"> An array of references to the load balancer IP configurations. </param>
        /// <param name="ipConfigurations"> An array of private link service IP configurations. </param>
        /// <param name="destinationIPAddress"> The destination IP address of the private link service. </param>
        /// <param name="networkInterfaces"> An array of references to the network interfaces created for this private link service. </param>
        /// <param name="provisioningState"> The provisioning state of the private link service resource. </param>
        /// <param name="privateEndpointConnections"> An array of list about connections to the private endpoint. </param>
        /// <param name="visibility"> The visibility list of the private link service. </param>
        /// <param name="autoApproval"> The auto-approval list of the private link service. </param>
        /// <param name="fqdns"> The list of Fqdn. </param>
        /// <param name="alias"> The alias of the private link service. </param>
        /// <param name="enableProxyProtocol"> Whether the private link service is enabled for proxy protocol or not. </param>
        internal PrivateLinkServiceData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ExtendedLocation extendedLocation, ETag? etag, IList<FrontendIPConfigurationData> loadBalancerFrontendIPConfigurations, IList<PrivateLinkServiceIPConfiguration> ipConfigurations, string destinationIPAddress, IReadOnlyList<NetworkInterfaceData> networkInterfaces, NetworkProvisioningState? provisioningState, IReadOnlyList<NetworkPrivateEndpointConnectionData> privateEndpointConnections, PrivateLinkServicePropertiesVisibility visibility, PrivateLinkServicePropertiesAutoApproval autoApproval, IList<string> fqdns, string @alias, bool? enableProxyProtocol) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            ExtendedLocation = extendedLocation;
            ETag = etag;
            LoadBalancerFrontendIPConfigurations = loadBalancerFrontendIPConfigurations;
            IPConfigurations = ipConfigurations;
            DestinationIPAddress = destinationIPAddress;
            NetworkInterfaces = networkInterfaces;
            ProvisioningState = provisioningState;
            PrivateEndpointConnections = privateEndpointConnections;
            Visibility = visibility;
            AutoApproval = autoApproval;
            Fqdns = fqdns;
            Alias = @alias;
            EnableProxyProtocol = enableProxyProtocol;
        }

        /// <summary> The extended location of the load balancer. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> An array of references to the load balancer IP configurations. </summary>
        public IList<FrontendIPConfigurationData> LoadBalancerFrontendIPConfigurations { get; }
        /// <summary> An array of private link service IP configurations. </summary>
        public IList<PrivateLinkServiceIPConfiguration> IPConfigurations { get; }
        /// <summary> The destination IP address of the private link service. </summary>
        public string DestinationIPAddress { get; set; }
        /// <summary> An array of references to the network interfaces created for this private link service. </summary>
        public IReadOnlyList<NetworkInterfaceData> NetworkInterfaces { get; }
        /// <summary> The provisioning state of the private link service resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> An array of list about connections to the private endpoint. </summary>
        public IReadOnlyList<NetworkPrivateEndpointConnectionData> PrivateEndpointConnections { get; }
        /// <summary> The visibility list of the private link service. </summary>
        internal PrivateLinkServicePropertiesVisibility Visibility { get; set; }
        /// <summary> The list of subscriptions. </summary>
        public IList<string> VisibilitySubscriptions
        {
            get
            {
                if (Visibility is null)
                    Visibility = new PrivateLinkServicePropertiesVisibility();
                return Visibility.Subscriptions;
            }
        }

        /// <summary> The auto-approval list of the private link service. </summary>
        internal PrivateLinkServicePropertiesAutoApproval AutoApproval { get; set; }
        /// <summary> The list of subscriptions. </summary>
        public IList<string> AutoApprovalSubscriptions
        {
            get
            {
                if (AutoApproval is null)
                    AutoApproval = new PrivateLinkServicePropertiesAutoApproval();
                return AutoApproval.Subscriptions;
            }
        }

        /// <summary> The list of Fqdn. </summary>
        public IList<string> Fqdns { get; }
        /// <summary> The alias of the private link service. </summary>
        public string Alias { get; }
        /// <summary> Whether the private link service is enabled for proxy protocol or not. </summary>
        public bool? EnableProxyProtocol { get; set; }
    }
}
