// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the NetworkVirtualApplianceConnection data model.
    /// NetworkVirtualApplianceConnection resource.
    /// </summary>
    public partial class NetworkVirtualApplianceConnectionData : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="NetworkVirtualApplianceConnectionData"/>. </summary>
        public NetworkVirtualApplianceConnectionData()
        {
            BgpPeerAddress = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkVirtualApplianceConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="namePropertiesName"> The name of the resource. </param>
        /// <param name="provisioningState"> The provisioning state of the NetworkVirtualApplianceConnection resource. </param>
        /// <param name="asn"> Network Virtual Appliance ASN. </param>
        /// <param name="tunnelIdentifier"> Unique identifier for the connection. </param>
        /// <param name="bgpPeerAddress"> List of bgpPeerAddresses for the NVA instances. </param>
        /// <param name="enableInternetSecurity"> Enable internet security. </param>
        /// <param name="connectionRoutingConfiguration"> The Routing Configuration indicating the associated and propagated route tables on this connection. </param>
        internal NetworkVirtualApplianceConnectionData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string namePropertiesName, NetworkProvisioningState? provisioningState, long? asn, long? tunnelIdentifier, IList<string> bgpPeerAddress, bool? enableInternetSecurity, RoutingConfiguration connectionRoutingConfiguration) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            NamePropertiesName = namePropertiesName;
            ProvisioningState = provisioningState;
            Asn = asn;
            TunnelIdentifier = tunnelIdentifier;
            BgpPeerAddress = bgpPeerAddress;
            EnableInternetSecurity = enableInternetSecurity;
            ConnectionRoutingConfiguration = connectionRoutingConfiguration;
        }

        /// <summary> The name of the resource. </summary>
        public string NamePropertiesName { get; set; }
        /// <summary> The provisioning state of the NetworkVirtualApplianceConnection resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Network Virtual Appliance ASN. </summary>
        public long? Asn { get; set; }
        /// <summary> Unique identifier for the connection. </summary>
        public long? TunnelIdentifier { get; set; }
        /// <summary> List of bgpPeerAddresses for the NVA instances. </summary>
        public IList<string> BgpPeerAddress { get; }
        /// <summary> Enable internet security. </summary>
        public bool? EnableInternetSecurity { get; set; }
        /// <summary> The Routing Configuration indicating the associated and propagated route tables on this connection. </summary>
        public RoutingConfiguration ConnectionRoutingConfiguration { get; set; }
    }
}
