// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the NetworkManagerSecurityUserRule data model.
    /// Network security user rule.
    /// </summary>
    public partial class NetworkManagerSecurityUserRuleData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkManagerSecurityUserRuleData"/>. </summary>
        public NetworkManagerSecurityUserRuleData()
        {
            Sources = new ChangeTrackingList<AddressPrefixItem>();
            Destinations = new ChangeTrackingList<AddressPrefixItem>();
            SourcePortRanges = new ChangeTrackingList<string>();
            DestinationPortRanges = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkManagerSecurityUserRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description for this rule. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the security configuration user rule resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkManagerSecurityUserRuleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, SecurityConfigurationRuleProtocol? protocol, IList<AddressPrefixItem> sources, IList<AddressPrefixItem> destinations, IList<string> sourcePortRanges, IList<string> destinationPortRanges, SecurityConfigurationRuleDirection? direction, NetworkProvisioningState? provisioningState, Guid? resourceGuid, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            Protocol = protocol;
            Sources = sources;
            Destinations = destinations;
            SourcePortRanges = sourcePortRanges;
            DestinationPortRanges = destinationPortRanges;
            Direction = direction;
            ProvisioningState = provisioningState;
            ResourceGuid = resourceGuid;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A description for this rule. </summary>
        public string Description { get; set; }
        /// <summary> Network protocol this rule applies to. </summary>
        public SecurityConfigurationRuleProtocol? Protocol { get; set; }
        /// <summary> The CIDR or source IP ranges. </summary>
        public IList<AddressPrefixItem> Sources { get; }
        /// <summary> The destination address prefixes. CIDR or destination IP ranges. </summary>
        public IList<AddressPrefixItem> Destinations { get; }
        /// <summary> The source port ranges. </summary>
        public IList<string> SourcePortRanges { get; }
        /// <summary> The destination port ranges. </summary>
        public IList<string> DestinationPortRanges { get; }
        /// <summary> Indicates if the traffic matched against the rule in inbound or outbound. </summary>
        public SecurityConfigurationRuleDirection? Direction { get; set; }
        /// <summary> The provisioning state of the security configuration user rule resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Unique identifier for this resource. </summary>
        public Guid? ResourceGuid { get; }
        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
    }
}
