// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the NetworkManager data model.
    /// The Managed Network resource
    /// </summary>
    public partial class NetworkManagerData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="NetworkManagerData"/>. </summary>
        public NetworkManagerData()
        {
            NetworkManagerScopeAccesses = new ChangeTrackingList<NetworkConfigurationDeploymentType>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkManagerData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="systemData"> The system metadata related to this resource. </param>
        /// <param name="description"> A description of the network manager. </param>
        /// <param name="networkManagerScopes"> Scope of Network Manager. </param>
        /// <param name="networkManagerScopeAccesses"> Scope Access. </param>
        /// <param name="provisioningState"> The provisioning state of the network manager resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        internal NetworkManagerData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, SystemData systemData, string description, NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes, IList<NetworkConfigurationDeploymentType> networkManagerScopeAccesses, NetworkProvisioningState? provisioningState, Guid? resourceGuid) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            ETag = etag;
            SystemData = systemData;
            Description = description;
            NetworkManagerScopes = networkManagerScopes;
            NetworkManagerScopeAccesses = networkManagerScopeAccesses;
            ProvisioningState = provisioningState;
            ResourceGuid = resourceGuid;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The system metadata related to this resource. </summary>
        public SystemData SystemData { get; }
        /// <summary> A description of the network manager. </summary>
        public string Description { get; set; }
        /// <summary> Scope of Network Manager. </summary>
        public NetworkManagerPropertiesNetworkManagerScopes NetworkManagerScopes { get; set; }
        /// <summary> Scope Access. </summary>
        public IList<NetworkConfigurationDeploymentType> NetworkManagerScopeAccesses { get; }
        /// <summary> The provisioning state of the network manager resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Unique identifier for this resource. </summary>
        public Guid? ResourceGuid { get; }
    }
}
