// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the NetworkInterfaceIPConfiguration data model.
    /// IPConfiguration in a network interface.
    /// </summary>
    public partial class NetworkInterfaceIPConfigurationData : NetworkWritableResourceData
    {
        /// <summary> Initializes a new instance of <see cref="NetworkInterfaceIPConfigurationData"/>. </summary>
        public NetworkInterfaceIPConfigurationData()
        {
            VirtualNetworkTaps = new ChangeTrackingList<VirtualNetworkTapData>();
            ApplicationGatewayBackendAddressPools = new ChangeTrackingList<ApplicationGatewayBackendAddressPool>();
            LoadBalancerBackendAddressPools = new ChangeTrackingList<BackendAddressPoolData>();
            LoadBalancerInboundNatRules = new ChangeTrackingList<InboundNatRuleData>();
            ApplicationSecurityGroups = new ChangeTrackingList<ApplicationSecurityGroupData>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkInterfaceIPConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="gatewayLoadBalancer"> The reference to gateway load balancer frontend IP. </param>
        /// <param name="virtualNetworkTaps"> The reference to Virtual Network Taps. </param>
        /// <param name="applicationGatewayBackendAddressPools"> The reference to ApplicationGatewayBackendAddressPool resource. </param>
        /// <param name="loadBalancerBackendAddressPools"> The reference to LoadBalancerBackendAddressPool resource. </param>
        /// <param name="loadBalancerInboundNatRules"> A list of references of LoadBalancerInboundNatRules. </param>
        /// <param name="privateIPAddress"> Private IP address of the IP configuration. It can be a single IP address or a CIDR block in the format &lt;address&gt;/&lt;prefix-length&gt;. </param>
        /// <param name="privateIPAddressPrefixLength"> The private IP address prefix length. If specified and the allocation method is dynamic, the service will allocate a CIDR block instead of a single IP address. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="privateIPAddressVersion"> Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. </param>
        /// <param name="subnet"> Subnet bound to the IP configuration. </param>
        /// <param name="primary"> Whether this is a primary customer address on the network interface. </param>
        /// <param name="publicIPAddress"> Public IP address bound to the IP configuration. </param>
        /// <param name="applicationSecurityGroups"> Application security groups in which the IP configuration is included. </param>
        /// <param name="provisioningState"> The provisioning state of the network interface IP configuration. </param>
        /// <param name="privateLinkConnectionProperties"> PrivateLinkConnection properties for the network interface. </param>
        internal NetworkInterfaceIPConfigurationData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, WritableSubResource gatewayLoadBalancer, IList<VirtualNetworkTapData> virtualNetworkTaps, IList<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools, IList<BackendAddressPoolData> loadBalancerBackendAddressPools, IList<InboundNatRuleData> loadBalancerInboundNatRules, string privateIPAddress, int? privateIPAddressPrefixLength, NetworkIPAllocationMethod? privateIPAllocationMethod, NetworkIPVersion? privateIPAddressVersion, SubnetData subnet, bool? primary, PublicIPAddressData publicIPAddress, IList<ApplicationSecurityGroupData> applicationSecurityGroups, NetworkProvisioningState? provisioningState, NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties privateLinkConnectionProperties) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            GatewayLoadBalancer = gatewayLoadBalancer;
            VirtualNetworkTaps = virtualNetworkTaps;
            ApplicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools;
            LoadBalancerBackendAddressPools = loadBalancerBackendAddressPools;
            LoadBalancerInboundNatRules = loadBalancerInboundNatRules;
            PrivateIPAddress = privateIPAddress;
            PrivateIPAddressPrefixLength = privateIPAddressPrefixLength;
            PrivateIPAllocationMethod = privateIPAllocationMethod;
            PrivateIPAddressVersion = privateIPAddressVersion;
            Subnet = subnet;
            Primary = primary;
            PublicIPAddress = publicIPAddress;
            ApplicationSecurityGroups = applicationSecurityGroups;
            ProvisioningState = provisioningState;
            PrivateLinkConnectionProperties = privateLinkConnectionProperties;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The reference to gateway load balancer frontend IP. </summary>
        internal WritableSubResource GatewayLoadBalancer { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier GatewayLoadBalancerId
        {
            get => GatewayLoadBalancer is null ? default : GatewayLoadBalancer.Id;
            set
            {
                if (GatewayLoadBalancer is null)
                    GatewayLoadBalancer = new WritableSubResource();
                GatewayLoadBalancer.Id = value;
            }
        }

        /// <summary> The reference to Virtual Network Taps. </summary>
        public IList<VirtualNetworkTapData> VirtualNetworkTaps { get; }
        /// <summary> The reference to ApplicationGatewayBackendAddressPool resource. </summary>
        public IList<ApplicationGatewayBackendAddressPool> ApplicationGatewayBackendAddressPools { get; }
        /// <summary> The reference to LoadBalancerBackendAddressPool resource. </summary>
        public IList<BackendAddressPoolData> LoadBalancerBackendAddressPools { get; }
        /// <summary> A list of references of LoadBalancerInboundNatRules. </summary>
        public IList<InboundNatRuleData> LoadBalancerInboundNatRules { get; }
        /// <summary> Private IP address of the IP configuration. It can be a single IP address or a CIDR block in the format &lt;address&gt;/&lt;prefix-length&gt;. </summary>
        public string PrivateIPAddress { get; set; }
        /// <summary> The private IP address prefix length. If specified and the allocation method is dynamic, the service will allocate a CIDR block instead of a single IP address. </summary>
        public int? PrivateIPAddressPrefixLength { get; set; }
        /// <summary> The private IP address allocation method. </summary>
        public NetworkIPAllocationMethod? PrivateIPAllocationMethod { get; set; }
        /// <summary> Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. </summary>
        public NetworkIPVersion? PrivateIPAddressVersion { get; set; }
        /// <summary> Subnet bound to the IP configuration. </summary>
        public SubnetData Subnet { get; set; }
        /// <summary> Whether this is a primary customer address on the network interface. </summary>
        public bool? Primary { get; set; }
        /// <summary> Public IP address bound to the IP configuration. </summary>
        public PublicIPAddressData PublicIPAddress { get; set; }
        /// <summary> Application security groups in which the IP configuration is included. </summary>
        public IList<ApplicationSecurityGroupData> ApplicationSecurityGroups { get; }
        /// <summary> The provisioning state of the network interface IP configuration. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> PrivateLinkConnection properties for the network interface. </summary>
        public NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties PrivateLinkConnectionProperties { get; }
    }
}
