// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Value indicating whether the IP address is DDoS workload protected or not. </summary>
    public readonly partial struct WorkloadProtectedFlag : IEquatable<WorkloadProtectedFlag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadProtectedFlag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadProtectedFlag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "False";
        private const string TrueValue = "True";

        /// <summary> False. </summary>
        public static WorkloadProtectedFlag False { get; } = new WorkloadProtectedFlag(FalseValue);
        /// <summary> True. </summary>
        public static WorkloadProtectedFlag True { get; } = new WorkloadProtectedFlag(TrueValue);
        /// <summary> Determines if two <see cref="WorkloadProtectedFlag"/> values are the same. </summary>
        public static bool operator ==(WorkloadProtectedFlag left, WorkloadProtectedFlag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadProtectedFlag"/> values are not the same. </summary>
        public static bool operator !=(WorkloadProtectedFlag left, WorkloadProtectedFlag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadProtectedFlag"/>. </summary>
        public static implicit operator WorkloadProtectedFlag(string value) => new WorkloadProtectedFlag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadProtectedFlag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadProtectedFlag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
