// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The rule type. </summary>
    public readonly partial struct WebApplicationFirewallRuleType : IEquatable<WebApplicationFirewallRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationFirewallRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationFirewallRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MatchRuleValue = "MatchRule";
        private const string RateLimitRuleValue = "RateLimitRule";
        private const string InvalidValue = "Invalid";

        /// <summary> MatchRule. </summary>
        public static WebApplicationFirewallRuleType MatchRule { get; } = new WebApplicationFirewallRuleType(MatchRuleValue);
        /// <summary> RateLimitRule. </summary>
        public static WebApplicationFirewallRuleType RateLimitRule { get; } = new WebApplicationFirewallRuleType(RateLimitRuleValue);
        /// <summary> Invalid. </summary>
        public static WebApplicationFirewallRuleType Invalid { get; } = new WebApplicationFirewallRuleType(InvalidValue);
        /// <summary> Determines if two <see cref="WebApplicationFirewallRuleType"/> values are the same. </summary>
        public static bool operator ==(WebApplicationFirewallRuleType left, WebApplicationFirewallRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationFirewallRuleType"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationFirewallRuleType left, WebApplicationFirewallRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationFirewallRuleType"/>. </summary>
        public static implicit operator WebApplicationFirewallRuleType(string value) => new WebApplicationFirewallRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationFirewallRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationFirewallRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
