// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Resource status of the policy. </summary>
    public readonly partial struct WebApplicationFirewallPolicyResourceState : IEquatable<WebApplicationFirewallPolicyResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationFirewallPolicyResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationFirewallPolicyResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string EnablingValue = "Enabling";
        private const string EnabledValue = "Enabled";
        private const string DisablingValue = "Disabling";
        private const string DisabledValue = "Disabled";
        private const string DeletingValue = "Deleting";

        /// <summary> Creating. </summary>
        public static WebApplicationFirewallPolicyResourceState Creating { get; } = new WebApplicationFirewallPolicyResourceState(CreatingValue);
        /// <summary> Enabling. </summary>
        public static WebApplicationFirewallPolicyResourceState Enabling { get; } = new WebApplicationFirewallPolicyResourceState(EnablingValue);
        /// <summary> Enabled. </summary>
        public static WebApplicationFirewallPolicyResourceState Enabled { get; } = new WebApplicationFirewallPolicyResourceState(EnabledValue);
        /// <summary> Disabling. </summary>
        public static WebApplicationFirewallPolicyResourceState Disabling { get; } = new WebApplicationFirewallPolicyResourceState(DisablingValue);
        /// <summary> Disabled. </summary>
        public static WebApplicationFirewallPolicyResourceState Disabled { get; } = new WebApplicationFirewallPolicyResourceState(DisabledValue);
        /// <summary> Deleting. </summary>
        public static WebApplicationFirewallPolicyResourceState Deleting { get; } = new WebApplicationFirewallPolicyResourceState(DeletingValue);
        /// <summary> Determines if two <see cref="WebApplicationFirewallPolicyResourceState"/> values are the same. </summary>
        public static bool operator ==(WebApplicationFirewallPolicyResourceState left, WebApplicationFirewallPolicyResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationFirewallPolicyResourceState"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationFirewallPolicyResourceState left, WebApplicationFirewallPolicyResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationFirewallPolicyResourceState"/>. </summary>
        public static implicit operator WebApplicationFirewallPolicyResourceState(string value) => new WebApplicationFirewallPolicyResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationFirewallPolicyResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationFirewallPolicyResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
