// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The mode of the policy. </summary>
    public readonly partial struct WebApplicationFirewallMode : IEquatable<WebApplicationFirewallMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationFirewallMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationFirewallMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreventionValue = "Prevention";
        private const string DetectionValue = "Detection";

        /// <summary> Prevention. </summary>
        public static WebApplicationFirewallMode Prevention { get; } = new WebApplicationFirewallMode(PreventionValue);
        /// <summary> Detection. </summary>
        public static WebApplicationFirewallMode Detection { get; } = new WebApplicationFirewallMode(DetectionValue);
        /// <summary> Determines if two <see cref="WebApplicationFirewallMode"/> values are the same. </summary>
        public static bool operator ==(WebApplicationFirewallMode left, WebApplicationFirewallMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationFirewallMode"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationFirewallMode left, WebApplicationFirewallMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationFirewallMode"/>. </summary>
        public static implicit operator WebApplicationFirewallMode(string value) => new WebApplicationFirewallMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationFirewallMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationFirewallMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
