// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VpnServerConfiguration PolicyGroup member. </summary>
    public partial class VpnServerConfigurationPolicyGroupMember
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VpnServerConfigurationPolicyGroupMember"/>. </summary>
        public VpnServerConfigurationPolicyGroupMember()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VpnServerConfigurationPolicyGroupMember"/>. </summary>
        /// <param name="name"> Name of the VpnServerConfigurationPolicyGroupMember. </param>
        /// <param name="attributeType"> The Vpn Policy member attribute type. </param>
        /// <param name="attributeValue"> The value of Attribute used for this VpnServerConfigurationPolicyGroupMember. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VpnServerConfigurationPolicyGroupMember(string name, VpnPolicyMemberAttributeType? attributeType, string attributeValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AttributeType = attributeType;
            AttributeValue = attributeValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the VpnServerConfigurationPolicyGroupMember. </summary>
        public string Name { get; set; }
        /// <summary> The Vpn Policy member attribute type. </summary>
        public VpnPolicyMemberAttributeType? AttributeType { get; set; }
        /// <summary> The value of Attribute used for this VpnServerConfigurationPolicyGroupMember. </summary>
        public string AttributeValue { get; set; }
    }
}
