// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class VpnPacketCaptureStartContent : IUtf8JsonSerializable, IJsonModel<VpnPacketCaptureStartContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VpnPacketCaptureStartContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VpnPacketCaptureStartContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VpnPacketCaptureStartContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FilterData))
            {
                writer.WritePropertyName("filterData"u8);
                writer.WriteStringValue(FilterData);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VpnPacketCaptureStartContent IJsonModel<VpnPacketCaptureStartContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VpnPacketCaptureStartContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVpnPacketCaptureStartContent(document.RootElement, options);
        }

        internal static VpnPacketCaptureStartContent DeserializeVpnPacketCaptureStartContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string filterData = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("filterData"u8))
                {
                    filterData = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VpnPacketCaptureStartContent(filterData, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VpnPacketCaptureStartContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VpnPacketCaptureStartContent)} does not support writing '{options.Format}' format.");
            }
        }

        VpnPacketCaptureStartContent IPersistableModel<VpnPacketCaptureStartContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVpnPacketCaptureStartContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VpnPacketCaptureStartContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VpnPacketCaptureStartContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
