// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Parameters for SharedKey. </summary>
    public partial class VpnLinkConnectionSharedKeyProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VpnLinkConnectionSharedKeyProperties"/>. </summary>
        public VpnLinkConnectionSharedKeyProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VpnLinkConnectionSharedKeyProperties"/>. </summary>
        /// <param name="sharedKey"> The value of the shared key for the vpn link connection. </param>
        /// <param name="sharedKeyLength"> The length of the shared key for the vpn link connection. </param>
        /// <param name="provisioningState"> The provisioning state of the SharedKey resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VpnLinkConnectionSharedKeyProperties(string sharedKey, int? sharedKeyLength, NetworkProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SharedKey = sharedKey;
            SharedKeyLength = sharedKeyLength;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The value of the shared key for the vpn link connection. </summary>
        public string SharedKey { get; set; }
        /// <summary> The length of the shared key for the vpn link connection. </summary>
        public int? SharedKeyLength { get; set; }
        /// <summary> The provisioning state of the SharedKey resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
