// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VPN protocol enabled for the VpnServerConfiguration. </summary>
    public readonly partial struct VpnGatewayTunnelingProtocol : IEquatable<VpnGatewayTunnelingProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VpnGatewayTunnelingProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VpnGatewayTunnelingProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IkeV2Value = "IkeV2";
        private const string OpenVpnValue = "OpenVPN";

        /// <summary> IkeV2. </summary>
        public static VpnGatewayTunnelingProtocol IkeV2 { get; } = new VpnGatewayTunnelingProtocol(IkeV2Value);
        /// <summary> OpenVPN. </summary>
        public static VpnGatewayTunnelingProtocol OpenVpn { get; } = new VpnGatewayTunnelingProtocol(OpenVpnValue);
        /// <summary> Determines if two <see cref="VpnGatewayTunnelingProtocol"/> values are the same. </summary>
        public static bool operator ==(VpnGatewayTunnelingProtocol left, VpnGatewayTunnelingProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VpnGatewayTunnelingProtocol"/> values are not the same. </summary>
        public static bool operator !=(VpnGatewayTunnelingProtocol left, VpnGatewayTunnelingProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VpnGatewayTunnelingProtocol"/>. </summary>
        public static implicit operator VpnGatewayTunnelingProtocol(string value) => new VpnGatewayTunnelingProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VpnGatewayTunnelingProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VpnGatewayTunnelingProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
