// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class VpnGatewayPacketCaptureStartContent : IUtf8JsonSerializable, IJsonModel<VpnGatewayPacketCaptureStartContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VpnGatewayPacketCaptureStartContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VpnGatewayPacketCaptureStartContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnGatewayPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VpnGatewayPacketCaptureStartContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FilterData))
            {
                writer.WritePropertyName("filterData"u8);
                writer.WriteStringValue(FilterData);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VpnGatewayPacketCaptureStartContent IJsonModel<VpnGatewayPacketCaptureStartContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnGatewayPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VpnGatewayPacketCaptureStartContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVpnGatewayPacketCaptureStartContent(document.RootElement, options);
        }

        internal static VpnGatewayPacketCaptureStartContent DeserializeVpnGatewayPacketCaptureStartContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string filterData = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("filterData"u8))
                {
                    filterData = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VpnGatewayPacketCaptureStartContent(filterData, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VpnGatewayPacketCaptureStartContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnGatewayPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VpnGatewayPacketCaptureStartContent)} does not support writing '{options.Format}' format.");
            }
        }

        VpnGatewayPacketCaptureStartContent IPersistableModel<VpnGatewayPacketCaptureStartContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnGatewayPacketCaptureStartContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVpnGatewayPacketCaptureStartContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VpnGatewayPacketCaptureStartContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VpnGatewayPacketCaptureStartContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
