// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> IP Configuration of a VPN Gateway Resource. </summary>
    public partial class VpnGatewayIPConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VpnGatewayIPConfiguration"/>. </summary>
        internal VpnGatewayIPConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VpnGatewayIPConfiguration"/>. </summary>
        /// <param name="id"> The identifier of the IP configuration for a VPN Gateway. </param>
        /// <param name="publicIPAddress"> The public IP address of this IP configuration. </param>
        /// <param name="privateIPAddress"> The private IP address of this IP configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VpnGatewayIPConfiguration(ResourceIdentifier id, string publicIPAddress, string privateIPAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PublicIPAddress = publicIPAddress;
            PrivateIPAddress = privateIPAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The identifier of the IP configuration for a VPN Gateway. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> The public IP address of this IP configuration. </summary>
        public string PublicIPAddress { get; }
        /// <summary> The private IP address of this IP configuration. </summary>
        public string PrivateIPAddress { get; }
    }
}
