// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VPN client root certificate of virtual network gateway. </summary>
    public partial class VpnClientRootCertificate : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="VpnClientRootCertificate"/>. </summary>
        /// <param name="publicCertData"> The certificate public data. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="publicCertData"/> is null. </exception>
        public VpnClientRootCertificate(BinaryData publicCertData)
        {
            Argument.AssertNotNull(publicCertData, nameof(publicCertData));

            PublicCertData = publicCertData;
        }

        /// <summary> Initializes a new instance of <see cref="VpnClientRootCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="publicCertData"> The certificate public data. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN client root certificate resource. </param>
        internal VpnClientRootCertificate(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, BinaryData publicCertData, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            PublicCertData = publicCertData;
            ProvisioningState = provisioningState;
        }

        /// <summary> Initializes a new instance of <see cref="VpnClientRootCertificate"/> for deserialization. </summary>
        internal VpnClientRootCertificate()
        {
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary>
        /// The certificate public data.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData PublicCertData { get; set; }
        /// <summary> The provisioning state of the VPN client root certificate resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
