// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VPN client revoked certificate of virtual network gateway. </summary>
    public partial class VpnClientRevokedCertificate : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="VpnClientRevokedCertificate"/>. </summary>
        public VpnClientRevokedCertificate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VpnClientRevokedCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="thumbprint"> The revoked VPN client certificate thumbprint. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN client revoked certificate resource. </param>
        internal VpnClientRevokedCertificate(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, string thumbprint, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            Thumbprint = thumbprint;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The revoked VPN client certificate thumbprint. </summary>
        public string Thumbprint { get; set; }
        /// <summary> The provisioning state of the VPN client revoked certificate resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
