// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VPN client protocol enabled for the virtual network gateway. </summary>
    public readonly partial struct VpnClientProtocol : IEquatable<VpnClientProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VpnClientProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VpnClientProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IkeV2Value = "IkeV2";
        private const string SstpValue = "SSTP";
        private const string OpenVpnValue = "OpenVPN";

        /// <summary> IkeV2. </summary>
        public static VpnClientProtocol IkeV2 { get; } = new VpnClientProtocol(IkeV2Value);
        /// <summary> SSTP. </summary>
        public static VpnClientProtocol Sstp { get; } = new VpnClientProtocol(SstpValue);
        /// <summary> OpenVPN. </summary>
        public static VpnClientProtocol OpenVpn { get; } = new VpnClientProtocol(OpenVpnValue);
        /// <summary> Determines if two <see cref="VpnClientProtocol"/> values are the same. </summary>
        public static bool operator ==(VpnClientProtocol left, VpnClientProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VpnClientProtocol"/> values are not the same. </summary>
        public static bool operator !=(VpnClientProtocol left, VpnClientProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VpnClientProtocol"/>. </summary>
        public static implicit operator VpnClientProtocol(string value) => new VpnClientProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VpnClientProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VpnClientProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
