// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> An IPSec parameters for a virtual network gateway P2S connection. </summary>
    public partial class VpnClientIPsecParameters
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VpnClientIPsecParameters"/>. </summary>
        /// <param name="saLifeTimeSeconds"> The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client. </param>
        /// <param name="saDataSizeKilobytes"> The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client.. </param>
        /// <param name="ipsecEncryption"> The IPSec encryption algorithm (IKE phase 1). </param>
        /// <param name="ipsecIntegrity"> The IPSec integrity algorithm (IKE phase 1). </param>
        /// <param name="ikeEncryption"> The IKE encryption algorithm (IKE phase 2). </param>
        /// <param name="ikeIntegrity"> The IKE integrity algorithm (IKE phase 2). </param>
        /// <param name="dhGroup"> The DH Group used in IKE Phase 1 for initial SA. </param>
        /// <param name="pfsGroup"> The Pfs Group used in IKE Phase 2 for new child SA. </param>
        public VpnClientIPsecParameters(int saLifeTimeSeconds, int saDataSizeKilobytes, IPsecEncryption ipsecEncryption, IPsecIntegrity ipsecIntegrity, IkeEncryption ikeEncryption, IkeIntegrity ikeIntegrity, DHGroup dhGroup, PfsGroup pfsGroup)
        {
            SaLifeTimeSeconds = saLifeTimeSeconds;
            SaDataSizeKilobytes = saDataSizeKilobytes;
            IPsecEncryption = ipsecEncryption;
            IPsecIntegrity = ipsecIntegrity;
            IkeEncryption = ikeEncryption;
            IkeIntegrity = ikeIntegrity;
            DhGroup = dhGroup;
            PfsGroup = pfsGroup;
        }

        /// <summary> Initializes a new instance of <see cref="VpnClientIPsecParameters"/>. </summary>
        /// <param name="saLifeTimeSeconds"> The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client. </param>
        /// <param name="saDataSizeKilobytes"> The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client.. </param>
        /// <param name="ipsecEncryption"> The IPSec encryption algorithm (IKE phase 1). </param>
        /// <param name="ipsecIntegrity"> The IPSec integrity algorithm (IKE phase 1). </param>
        /// <param name="ikeEncryption"> The IKE encryption algorithm (IKE phase 2). </param>
        /// <param name="ikeIntegrity"> The IKE integrity algorithm (IKE phase 2). </param>
        /// <param name="dhGroup"> The DH Group used in IKE Phase 1 for initial SA. </param>
        /// <param name="pfsGroup"> The Pfs Group used in IKE Phase 2 for new child SA. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VpnClientIPsecParameters(int saLifeTimeSeconds, int saDataSizeKilobytes, IPsecEncryption ipsecEncryption, IPsecIntegrity ipsecIntegrity, IkeEncryption ikeEncryption, IkeIntegrity ikeIntegrity, DHGroup dhGroup, PfsGroup pfsGroup, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SaLifeTimeSeconds = saLifeTimeSeconds;
            SaDataSizeKilobytes = saDataSizeKilobytes;
            IPsecEncryption = ipsecEncryption;
            IPsecIntegrity = ipsecIntegrity;
            IkeEncryption = ikeEncryption;
            IkeIntegrity = ikeIntegrity;
            DhGroup = dhGroup;
            PfsGroup = pfsGroup;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="VpnClientIPsecParameters"/> for deserialization. </summary>
        internal VpnClientIPsecParameters()
        {
        }

        /// <summary> The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client. </summary>
        public int SaLifeTimeSeconds { get; set; }
        /// <summary> The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client.. </summary>
        public int SaDataSizeKilobytes { get; set; }
        /// <summary> The IPSec encryption algorithm (IKE phase 1). </summary>
        public IPsecEncryption IPsecEncryption { get; set; }
        /// <summary> The IPSec integrity algorithm (IKE phase 1). </summary>
        public IPsecIntegrity IPsecIntegrity { get; set; }
        /// <summary> The IKE encryption algorithm (IKE phase 2). </summary>
        public IkeEncryption IkeEncryption { get; set; }
        /// <summary> The IKE integrity algorithm (IKE phase 2). </summary>
        public IkeIntegrity IkeIntegrity { get; set; }
        /// <summary> The DH Group used in IKE Phase 1 for initial SA. </summary>
        public DHGroup DhGroup { get; set; }
        /// <summary> The Pfs Group used in IKE Phase 2 for new child SA. </summary>
        public PfsGroup PfsGroup { get; set; }
    }
}
