// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class VpnClientConnectionHealth : IUtf8JsonSerializable, IJsonModel<VpnClientConnectionHealth>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VpnClientConnectionHealth>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VpnClientConnectionHealth>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnClientConnectionHealth>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VpnClientConnectionHealth)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(TotalIngressBytesTransferred))
            {
                writer.WritePropertyName("totalIngressBytesTransferred"u8);
                writer.WriteNumberValue(TotalIngressBytesTransferred.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalEgressBytesTransferred))
            {
                writer.WritePropertyName("totalEgressBytesTransferred"u8);
                writer.WriteNumberValue(TotalEgressBytesTransferred.Value);
            }
            if (Optional.IsDefined(VpnClientConnectionsCount))
            {
                writer.WritePropertyName("vpnClientConnectionsCount"u8);
                writer.WriteNumberValue(VpnClientConnectionsCount.Value);
            }
            if (Optional.IsCollectionDefined(AllocatedIPAddresses))
            {
                writer.WritePropertyName("allocatedIpAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in AllocatedIPAddresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VpnClientConnectionHealth IJsonModel<VpnClientConnectionHealth>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnClientConnectionHealth>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VpnClientConnectionHealth)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVpnClientConnectionHealth(document.RootElement, options);
        }

        internal static VpnClientConnectionHealth DeserializeVpnClientConnectionHealth(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? totalIngressBytesTransferred = default;
            long? totalEgressBytesTransferred = default;
            int? vpnClientConnectionsCount = default;
            IReadOnlyList<string> allocatedIPAddresses = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("totalIngressBytesTransferred"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalIngressBytesTransferred = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("totalEgressBytesTransferred"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalEgressBytesTransferred = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("vpnClientConnectionsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vpnClientConnectionsCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allocatedIpAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    allocatedIPAddresses = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VpnClientConnectionHealth(totalIngressBytesTransferred, totalEgressBytesTransferred, vpnClientConnectionsCount, allocatedIPAddresses ?? new ChangeTrackingList<string>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VpnClientConnectionHealth>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnClientConnectionHealth>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VpnClientConnectionHealth)} does not support writing '{options.Format}' format.");
            }
        }

        VpnClientConnectionHealth IPersistableModel<VpnClientConnectionHealth>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VpnClientConnectionHealth>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVpnClientConnectionHealth(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VpnClientConnectionHealth)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VpnClientConnectionHealth>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
