// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke vnet. </summary>
    public readonly partial struct VnetLocalRouteOverrideCriterion : IEquatable<VnetLocalRouteOverrideCriterion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VnetLocalRouteOverrideCriterion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VnetLocalRouteOverrideCriterion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ContainsValue = "Contains";
        private const string EqualValue = "Equal";

        /// <summary> Contains. </summary>
        public static VnetLocalRouteOverrideCriterion Contains { get; } = new VnetLocalRouteOverrideCriterion(ContainsValue);
        /// <summary> Equal. </summary>
        public static VnetLocalRouteOverrideCriterion Equal { get; } = new VnetLocalRouteOverrideCriterion(EqualValue);
        /// <summary> Determines if two <see cref="VnetLocalRouteOverrideCriterion"/> values are the same. </summary>
        public static bool operator ==(VnetLocalRouteOverrideCriterion left, VnetLocalRouteOverrideCriterion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VnetLocalRouteOverrideCriterion"/> values are not the same. </summary>
        public static bool operator !=(VnetLocalRouteOverrideCriterion left, VnetLocalRouteOverrideCriterion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VnetLocalRouteOverrideCriterion"/>. </summary>
        public static implicit operator VnetLocalRouteOverrideCriterion(string value) => new VnetLocalRouteOverrideCriterion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VnetLocalRouteOverrideCriterion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VnetLocalRouteOverrideCriterion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
