// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Enable or Disable apply network policies on private end point in the subnet. </summary>
    public readonly partial struct VirtualNetworkPrivateEndpointNetworkPolicy : IEquatable<VirtualNetworkPrivateEndpointNetworkPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkPrivateEndpointNetworkPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkPrivateEndpointNetworkPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string NetworkSecurityGroupEnabledValue = "NetworkSecurityGroupEnabled";
        private const string RouteTableEnabledValue = "RouteTableEnabled";

        /// <summary> Enabled. </summary>
        public static VirtualNetworkPrivateEndpointNetworkPolicy Enabled { get; } = new VirtualNetworkPrivateEndpointNetworkPolicy(EnabledValue);
        /// <summary> Disabled. </summary>
        public static VirtualNetworkPrivateEndpointNetworkPolicy Disabled { get; } = new VirtualNetworkPrivateEndpointNetworkPolicy(DisabledValue);
        /// <summary> NetworkSecurityGroupEnabled. </summary>
        public static VirtualNetworkPrivateEndpointNetworkPolicy NetworkSecurityGroupEnabled { get; } = new VirtualNetworkPrivateEndpointNetworkPolicy(NetworkSecurityGroupEnabledValue);
        /// <summary> RouteTableEnabled. </summary>
        public static VirtualNetworkPrivateEndpointNetworkPolicy RouteTableEnabled { get; } = new VirtualNetworkPrivateEndpointNetworkPolicy(RouteTableEnabledValue);
        /// <summary> Determines if two <see cref="VirtualNetworkPrivateEndpointNetworkPolicy"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkPrivateEndpointNetworkPolicy left, VirtualNetworkPrivateEndpointNetworkPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkPrivateEndpointNetworkPolicy"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkPrivateEndpointNetworkPolicy left, VirtualNetworkPrivateEndpointNetworkPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkPrivateEndpointNetworkPolicy"/>. </summary>
        public static implicit operator VirtualNetworkPrivateEndpointNetworkPolicy(string value) => new VirtualNetworkPrivateEndpointNetworkPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkPrivateEndpointNetworkPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkPrivateEndpointNetworkPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
