// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The peering sync status of the virtual network peering. </summary>
    public readonly partial struct VirtualNetworkPeeringLevel : IEquatable<VirtualNetworkPeeringLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkPeeringLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkPeeringLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FullyInSyncValue = "FullyInSync";
        private const string RemoteNotInSyncValue = "RemoteNotInSync";
        private const string LocalNotInSyncValue = "LocalNotInSync";
        private const string LocalAndRemoteNotInSyncValue = "LocalAndRemoteNotInSync";

        /// <summary> FullyInSync. </summary>
        public static VirtualNetworkPeeringLevel FullyInSync { get; } = new VirtualNetworkPeeringLevel(FullyInSyncValue);
        /// <summary> RemoteNotInSync. </summary>
        public static VirtualNetworkPeeringLevel RemoteNotInSync { get; } = new VirtualNetworkPeeringLevel(RemoteNotInSyncValue);
        /// <summary> LocalNotInSync. </summary>
        public static VirtualNetworkPeeringLevel LocalNotInSync { get; } = new VirtualNetworkPeeringLevel(LocalNotInSyncValue);
        /// <summary> LocalAndRemoteNotInSync. </summary>
        public static VirtualNetworkPeeringLevel LocalAndRemoteNotInSync { get; } = new VirtualNetworkPeeringLevel(LocalAndRemoteNotInSyncValue);
        /// <summary> Determines if two <see cref="VirtualNetworkPeeringLevel"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkPeeringLevel left, VirtualNetworkPeeringLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkPeeringLevel"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkPeeringLevel left, VirtualNetworkPeeringLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkPeeringLevel"/>. </summary>
        public static implicit operator VirtualNetworkPeeringLevel(string value) => new VirtualNetworkPeeringLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkPeeringLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkPeeringLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
