// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The type of this virtual network gateway. </summary>
    public readonly partial struct VirtualNetworkGatewayType : IEquatable<VirtualNetworkGatewayType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkGatewayType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkGatewayType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VpnValue = "Vpn";
        private const string ExpressRouteValue = "ExpressRoute";
        private const string LocalGatewayValue = "LocalGateway";

        /// <summary> Vpn. </summary>
        public static VirtualNetworkGatewayType Vpn { get; } = new VirtualNetworkGatewayType(VpnValue);
        /// <summary> ExpressRoute. </summary>
        public static VirtualNetworkGatewayType ExpressRoute { get; } = new VirtualNetworkGatewayType(ExpressRouteValue);
        /// <summary> LocalGateway. </summary>
        public static VirtualNetworkGatewayType LocalGateway { get; } = new VirtualNetworkGatewayType(LocalGatewayValue);
        /// <summary> Determines if two <see cref="VirtualNetworkGatewayType"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkGatewayType left, VirtualNetworkGatewayType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkGatewayType"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkGatewayType left, VirtualNetworkGatewayType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkGatewayType"/>. </summary>
        public static implicit operator VirtualNetworkGatewayType(string value) => new VirtualNetworkGatewayType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkGatewayType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkGatewayType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
