// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Gateway connection protocol. </summary>
    public readonly partial struct VirtualNetworkGatewayConnectionProtocol : IEquatable<VirtualNetworkGatewayConnectionProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkGatewayConnectionProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkGatewayConnectionProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IkeV2Value = "IKEv2";
        private const string IkeV1Value = "IKEv1";

        /// <summary> IKEv2. </summary>
        public static VirtualNetworkGatewayConnectionProtocol IkeV2 { get; } = new VirtualNetworkGatewayConnectionProtocol(IkeV2Value);
        /// <summary> IKEv1. </summary>
        public static VirtualNetworkGatewayConnectionProtocol IkeV1 { get; } = new VirtualNetworkGatewayConnectionProtocol(IkeV1Value);
        /// <summary> Determines if two <see cref="VirtualNetworkGatewayConnectionProtocol"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkGatewayConnectionProtocol left, VirtualNetworkGatewayConnectionProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkGatewayConnectionProtocol"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkGatewayConnectionProtocol left, VirtualNetworkGatewayConnectionProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkGatewayConnectionProtocol"/>. </summary>
        public static implicit operator VirtualNetworkGatewayConnectionProtocol(string value) => new VirtualNetworkGatewayConnectionProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkGatewayConnectionProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkGatewayConnectionProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
