// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> If the encrypted VNet allows VM that does not support encryption. This field is for future support, AllowUnencrypted is the only supported value at general availability. </summary>
    public readonly partial struct VirtualNetworkEncryptionEnforcement : IEquatable<VirtualNetworkEncryptionEnforcement>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkEncryptionEnforcement"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkEncryptionEnforcement(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DropUnencryptedValue = "DropUnencrypted";
        private const string AllowUnencryptedValue = "AllowUnencrypted";

        /// <summary> DropUnencrypted. </summary>
        public static VirtualNetworkEncryptionEnforcement DropUnencrypted { get; } = new VirtualNetworkEncryptionEnforcement(DropUnencryptedValue);
        /// <summary> AllowUnencrypted. </summary>
        public static VirtualNetworkEncryptionEnforcement AllowUnencrypted { get; } = new VirtualNetworkEncryptionEnforcement(AllowUnencryptedValue);
        /// <summary> Determines if two <see cref="VirtualNetworkEncryptionEnforcement"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkEncryptionEnforcement left, VirtualNetworkEncryptionEnforcement right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkEncryptionEnforcement"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkEncryptionEnforcement left, VirtualNetworkEncryptionEnforcement right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkEncryptionEnforcement"/>. </summary>
        public static implicit operator VirtualNetworkEncryptionEnforcement(string value) => new VirtualNetworkEncryptionEnforcement(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkEncryptionEnforcement other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkEncryptionEnforcement other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
