// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VirtualHub route. </summary>
    public partial class VirtualHubRoute
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualHubRoute"/>. </summary>
        public VirtualHubRoute()
        {
            AddressPrefixes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="VirtualHubRoute"/>. </summary>
        /// <param name="addressPrefixes"> List of all addressPrefixes. </param>
        /// <param name="nextHopIPAddress"> NextHop ip address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualHubRoute(IList<string> addressPrefixes, string nextHopIPAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AddressPrefixes = addressPrefixes;
            NextHopIPAddress = nextHopIPAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of all addressPrefixes. </summary>
        public IList<string> AddressPrefixes { get; }
        /// <summary> NextHop ip address. </summary>
        public string NextHopIPAddress { get; set; }
    }
}
