// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network Virtual Appliance NIC properties. </summary>
    public partial class VirtualApplianceNicProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualApplianceNicProperties"/>. </summary>
        internal VirtualApplianceNicProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualApplianceNicProperties"/>. </summary>
        /// <param name="nicType"> NIC type - PublicNic, PrivateNic, or AdditionalNic. </param>
        /// <param name="name"> NIC name. </param>
        /// <param name="publicIPAddress"> Public IP address. </param>
        /// <param name="privateIPAddress"> Private IP address. </param>
        /// <param name="instanceName"> Instance on which nic is attached. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualApplianceNicProperties(NicTypeInResponse? nicType, string name, string publicIPAddress, string privateIPAddress, string instanceName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NicType = nicType;
            Name = name;
            PublicIPAddress = publicIPAddress;
            PrivateIPAddress = privateIPAddress;
            InstanceName = instanceName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> NIC type - PublicNic, PrivateNic, or AdditionalNic. </summary>
        public NicTypeInResponse? NicType { get; }
        /// <summary> NIC name. </summary>
        public string Name { get; }
        /// <summary> Public IP address. </summary>
        public string PublicIPAddress { get; }
        /// <summary> Private IP address. </summary>
        public string PrivateIPAddress { get; }
        /// <summary> Instance on which nic is attached. </summary>
        public string InstanceName { get; }
    }
}
