// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Represents a single IP configuration. </summary>
    public partial class VirtualApplianceIPConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualApplianceIPConfiguration"/>. </summary>
        public VirtualApplianceIPConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualApplianceIPConfiguration"/>. </summary>
        /// <param name="name"> Name of the IP configuration. </param>
        /// <param name="properties"> Represents a single IP configuration properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualApplianceIPConfiguration(string name, VirtualApplianceIPConfigurationProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the IP configuration. </summary>
        public string Name { get; set; }
        /// <summary> Represents a single IP configuration properties. </summary>
        internal VirtualApplianceIPConfigurationProperties Properties { get; set; }
        /// <summary> Whether or not this is primary IP configuration of the NIC. </summary>
        public bool? IsPrimary
        {
            get => Properties is null ? default : Properties.IsPrimary;
            set
            {
                if (Properties is null)
                    Properties = new VirtualApplianceIPConfigurationProperties();
                Properties.IsPrimary = value;
            }
        }
    }
}
