// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network Virtual Appliance Additional NIC properties. </summary>
    public partial class VirtualApplianceAdditionalNicProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualApplianceAdditionalNicProperties"/>. </summary>
        public VirtualApplianceAdditionalNicProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualApplianceAdditionalNicProperties"/>. </summary>
        /// <param name="name"> Name of additional nic. </param>
        /// <param name="hasPublicIP"> Flag (true or false) for Intent for Public Ip on additional nic. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualApplianceAdditionalNicProperties(string name, bool? hasPublicIP, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            HasPublicIP = hasPublicIP;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of additional nic. </summary>
        public string Name { get; set; }
        /// <summary> Flag (true or false) for Intent for Public Ip on additional nic. </summary>
        public bool? HasPublicIP { get; set; }
    }
}
