// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class VerificationIPFlowContent : IUtf8JsonSerializable, IJsonModel<VerificationIPFlowContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VerificationIPFlowContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VerificationIPFlowContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VerificationIPFlowContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VerificationIPFlowContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("targetResourceId"u8);
            writer.WriteStringValue(TargetResourceId);
            writer.WritePropertyName("direction"u8);
            writer.WriteStringValue(Direction.ToString());
            writer.WritePropertyName("protocol"u8);
            writer.WriteStringValue(Protocol.ToString());
            writer.WritePropertyName("localPort"u8);
            writer.WriteStringValue(LocalPort);
            writer.WritePropertyName("remotePort"u8);
            writer.WriteStringValue(RemotePort);
            writer.WritePropertyName("localIPAddress"u8);
            writer.WriteStringValue(LocalIPAddress);
            writer.WritePropertyName("remoteIPAddress"u8);
            writer.WriteStringValue(RemoteIPAddress);
            if (Optional.IsDefined(TargetNicResourceId))
            {
                writer.WritePropertyName("targetNicResourceId"u8);
                writer.WriteStringValue(TargetNicResourceId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VerificationIPFlowContent IJsonModel<VerificationIPFlowContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VerificationIPFlowContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VerificationIPFlowContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVerificationIPFlowContent(document.RootElement, options);
        }

        internal static VerificationIPFlowContent DeserializeVerificationIPFlowContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier targetResourceId = default;
            NetworkTrafficDirection direction = default;
            IPFlowProtocol protocol = default;
            string localPort = default;
            string remotePort = default;
            string localIPAddress = default;
            string remoteIPAddress = default;
            ResourceIdentifier targetNicResourceId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("targetResourceId"u8))
                {
                    targetResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("direction"u8))
                {
                    direction = new NetworkTrafficDirection(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("protocol"u8))
                {
                    protocol = new IPFlowProtocol(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("localPort"u8))
                {
                    localPort = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("remotePort"u8))
                {
                    remotePort = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("localIPAddress"u8))
                {
                    localIPAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("remoteIPAddress"u8))
                {
                    remoteIPAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetNicResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetNicResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VerificationIPFlowContent(
                targetResourceId,
                direction,
                protocol,
                localPort,
                remotePort,
                localIPAddress,
                remoteIPAddress,
                targetNicResourceId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VerificationIPFlowContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VerificationIPFlowContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VerificationIPFlowContent)} does not support writing '{options.Format}' format.");
            }
        }

        VerificationIPFlowContent IPersistableModel<VerificationIPFlowContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VerificationIPFlowContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVerificationIPFlowContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VerificationIPFlowContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VerificationIPFlowContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
