// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VirtualNetworkGatewayConnection properties. </summary>
    public partial class TunnelConnectionHealth
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TunnelConnectionHealth"/>. </summary>
        internal TunnelConnectionHealth()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TunnelConnectionHealth"/>. </summary>
        /// <param name="tunnel"> Tunnel name. </param>
        /// <param name="connectionStatus"> Virtual Network Gateway connection status. </param>
        /// <param name="ingressBytesTransferred"> The Ingress Bytes Transferred in this connection. </param>
        /// <param name="egressBytesTransferred"> The Egress Bytes Transferred in this connection. </param>
        /// <param name="lastConnectionEstablishedOn"> The time at which connection was established in Utc format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TunnelConnectionHealth(string tunnel, VirtualNetworkGatewayConnectionStatus? connectionStatus, long? ingressBytesTransferred, long? egressBytesTransferred, string lastConnectionEstablishedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tunnel = tunnel;
            ConnectionStatus = connectionStatus;
            IngressBytesTransferred = ingressBytesTransferred;
            EgressBytesTransferred = egressBytesTransferred;
            LastConnectionEstablishedOn = lastConnectionEstablishedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Tunnel name. </summary>
        public string Tunnel { get; }
        /// <summary> Virtual Network Gateway connection status. </summary>
        public VirtualNetworkGatewayConnectionStatus? ConnectionStatus { get; }
        /// <summary> The Ingress Bytes Transferred in this connection. </summary>
        public long? IngressBytesTransferred { get; }
        /// <summary> The Egress Bytes Transferred in this connection. </summary>
        public long? EgressBytesTransferred { get; }
        /// <summary> The time at which connection was established in Utc format. </summary>
        public string LastConnectionEstablishedOn { get; }
    }
}
