// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Parameters that define the resource to troubleshoot. </summary>
    public partial class TroubleshootingContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TroubleshootingContent"/>. </summary>
        /// <param name="targetResourceId"> The target resource to troubleshoot. </param>
        /// <param name="storageId"> The ID for the storage account to save the troubleshoot result. </param>
        /// <param name="storageUri"> The path to the blob to save the troubleshoot result in. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetResourceId"/>, <paramref name="storageId"/> or <paramref name="storageUri"/> is null. </exception>
        public TroubleshootingContent(ResourceIdentifier targetResourceId, ResourceIdentifier storageId, Uri storageUri)
        {
            Argument.AssertNotNull(targetResourceId, nameof(targetResourceId));
            Argument.AssertNotNull(storageId, nameof(storageId));
            Argument.AssertNotNull(storageUri, nameof(storageUri));

            TargetResourceId = targetResourceId;
            StorageId = storageId;
            StorageUri = storageUri;
        }

        /// <summary> Initializes a new instance of <see cref="TroubleshootingContent"/>. </summary>
        /// <param name="targetResourceId"> The target resource to troubleshoot. </param>
        /// <param name="storageId"> The ID for the storage account to save the troubleshoot result. </param>
        /// <param name="storageUri"> The path to the blob to save the troubleshoot result in. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TroubleshootingContent(ResourceIdentifier targetResourceId, ResourceIdentifier storageId, Uri storageUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetResourceId = targetResourceId;
            StorageId = storageId;
            StorageUri = storageUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TroubleshootingContent"/> for deserialization. </summary>
        internal TroubleshootingContent()
        {
        }

        /// <summary> The target resource to troubleshoot. </summary>
        public ResourceIdentifier TargetResourceId { get; }
        /// <summary> The ID for the storage account to save the troubleshoot result. </summary>
        public ResourceIdentifier StorageId { get; }
        /// <summary> The path to the blob to save the troubleshoot result in. </summary>
        public Uri StorageUri { get; }
    }
}
