// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Parameters that define the representation of topology. </summary>
    public partial class TopologyContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TopologyContent"/>. </summary>
        public TopologyContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TopologyContent"/>. </summary>
        /// <param name="targetResourceGroupName"> The name of the target resource group to perform topology on. </param>
        /// <param name="targetVirtualNetwork"> The reference to the Virtual Network resource. </param>
        /// <param name="targetSubnet"> The reference to the Subnet resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TopologyContent(string targetResourceGroupName, WritableSubResource targetVirtualNetwork, WritableSubResource targetSubnet, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetResourceGroupName = targetResourceGroupName;
            TargetVirtualNetwork = targetVirtualNetwork;
            TargetSubnet = targetSubnet;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the target resource group to perform topology on. </summary>
        public string TargetResourceGroupName { get; set; }
        /// <summary> The reference to the Virtual Network resource. </summary>
        internal WritableSubResource TargetVirtualNetwork { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier TargetVirtualNetworkId
        {
            get => TargetVirtualNetwork is null ? default : TargetVirtualNetwork.Id;
            set
            {
                if (TargetVirtualNetwork is null)
                    TargetVirtualNetwork = new WritableSubResource();
                TargetVirtualNetwork.Id = value;
            }
        }

        /// <summary> The reference to the Subnet resource. </summary>
        internal WritableSubResource TargetSubnet { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier TargetSubnetId
        {
            get => TargetSubnet is null ? default : TargetSubnet.Id;
            set
            {
                if (TargetSubnet is null)
                    TargetSubnet = new WritableSubResource();
                TargetSubnet.Id = value;
            }
        }
    }
}
