// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters. </summary>
    public readonly partial struct TestEvalPreferredIPVersion : IEquatable<TestEvalPreferredIPVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TestEvalPreferredIPVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TestEvalPreferredIPVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPv4Value = "IPv4";
        private const string IPv6Value = "IPv6";

        /// <summary> IPv4. </summary>
        public static TestEvalPreferredIPVersion IPv4 { get; } = new TestEvalPreferredIPVersion(IPv4Value);
        /// <summary> IPv6. </summary>
        public static TestEvalPreferredIPVersion IPv6 { get; } = new TestEvalPreferredIPVersion(IPv6Value);
        /// <summary> Determines if two <see cref="TestEvalPreferredIPVersion"/> values are the same. </summary>
        public static bool operator ==(TestEvalPreferredIPVersion left, TestEvalPreferredIPVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TestEvalPreferredIPVersion"/> values are not the same. </summary>
        public static bool operator !=(TestEvalPreferredIPVersion left, TestEvalPreferredIPVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TestEvalPreferredIPVersion"/>. </summary>
        public static implicit operator TestEvalPreferredIPVersion(string value) => new TestEvalPreferredIPVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TestEvalPreferredIPVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TestEvalPreferredIPVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
