// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Configuration for static routes on this HubVnetConnectionConfiguration for static routes on this HubVnetConnection. </summary>
    public partial class StaticRoutesConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StaticRoutesConfig"/>. </summary>
        public StaticRoutesConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StaticRoutesConfig"/>. </summary>
        /// <param name="propagateStaticRoutes"> Boolean indicating whether static routes on this connection are automatically propagate to route tables which this connection propagates to. </param>
        /// <param name="vnetLocalRouteOverrideCriteria"> Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StaticRoutesConfig(bool? propagateStaticRoutes, VnetLocalRouteOverrideCriterion? vnetLocalRouteOverrideCriteria, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PropagateStaticRoutes = propagateStaticRoutes;
            VnetLocalRouteOverrideCriteria = vnetLocalRouteOverrideCriteria;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Boolean indicating whether static routes on this connection are automatically propagate to route tables which this connection propagates to. </summary>
        public bool? PropagateStaticRoutes { get; }
        /// <summary> Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke. </summary>
        public VnetLocalRouteOverrideCriterion? VnetLocalRouteOverrideCriteria { get; set; }
    }
}
