// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class StaticRoutesConfig : IUtf8JsonSerializable, IJsonModel<StaticRoutesConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StaticRoutesConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StaticRoutesConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StaticRoutesConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StaticRoutesConfig)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(PropagateStaticRoutes))
            {
                writer.WritePropertyName("propagateStaticRoutes"u8);
                writer.WriteBooleanValue(PropagateStaticRoutes.Value);
            }
            if (Optional.IsDefined(VnetLocalRouteOverrideCriteria))
            {
                writer.WritePropertyName("vnetLocalRouteOverrideCriteria"u8);
                writer.WriteStringValue(VnetLocalRouteOverrideCriteria.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StaticRoutesConfig IJsonModel<StaticRoutesConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StaticRoutesConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StaticRoutesConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStaticRoutesConfig(document.RootElement, options);
        }

        internal static StaticRoutesConfig DeserializeStaticRoutesConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? propagateStaticRoutes = default;
            VnetLocalRouteOverrideCriterion? vnetLocalRouteOverrideCriteria = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("propagateStaticRoutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    propagateStaticRoutes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("vnetLocalRouteOverrideCriteria"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vnetLocalRouteOverrideCriteria = new VnetLocalRouteOverrideCriterion(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StaticRoutesConfig(propagateStaticRoutes, vnetLocalRouteOverrideCriteria, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StaticRoutesConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StaticRoutesConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StaticRoutesConfig)} does not support writing '{options.Format}' format.");
            }
        }

        StaticRoutesConfig IPersistableModel<StaticRoutesConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StaticRoutesConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStaticRoutesConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StaticRoutesConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StaticRoutesConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
