// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> List of all Static Routes. </summary>
    public partial class StaticRoute
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StaticRoute"/>. </summary>
        public StaticRoute()
        {
            AddressPrefixes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="StaticRoute"/>. </summary>
        /// <param name="name"> The name of the StaticRoute that is unique within a VnetRoute. </param>
        /// <param name="addressPrefixes"> List of all address prefixes. </param>
        /// <param name="nextHopIPAddress"> The ip address of the next hop. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StaticRoute(string name, IList<string> addressPrefixes, string nextHopIPAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AddressPrefixes = addressPrefixes;
            NextHopIPAddress = nextHopIPAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the StaticRoute that is unique within a VnetRoute. </summary>
        public string Name { get; set; }
        /// <summary> List of all address prefixes. </summary>
        public IList<string> AddressPrefixes { get; }
        /// <summary> The ip address of the next hop. </summary>
        public string NextHopIPAddress { get; set; }
    }
}
