// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Set this property to Tenant to allow sharing subnet with other subscriptions in your AAD tenant. This property can only be set if defaultOutboundAccess is set to false, both properties can only be set if subnet is empty. </summary>
    public readonly partial struct SharingScope : IEquatable<SharingScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SharingScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SharingScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TenantValue = "Tenant";
        private const string DelegatedServicesValue = "DelegatedServices";

        /// <summary> Tenant. </summary>
        public static SharingScope Tenant { get; } = new SharingScope(TenantValue);
        /// <summary> DelegatedServices. </summary>
        public static SharingScope DelegatedServices { get; } = new SharingScope(DelegatedServicesValue);
        /// <summary> Determines if two <see cref="SharingScope"/> values are the same. </summary>
        public static bool operator ==(SharingScope left, SharingScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SharingScope"/> values are not the same. </summary>
        public static bool operator !=(SharingScope left, SharingScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SharingScope"/>. </summary>
        public static implicit operator SharingScope(string value) => new SharingScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SharingScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SharingScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
