// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Properties of the service tag information. </summary>
    public partial class ServiceTagInformationPropertiesFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceTagInformationPropertiesFormat"/>. </summary>
        internal ServiceTagInformationPropertiesFormat()
        {
            AddressPrefixes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ServiceTagInformationPropertiesFormat"/>. </summary>
        /// <param name="changeNumber"> The iteration number of service tag. </param>
        /// <param name="region"> The region of service tag. </param>
        /// <param name="systemService"> The name of system service. </param>
        /// <param name="addressPrefixes"> The list of IP address prefixes. </param>
        /// <param name="state"> The state of the service tag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceTagInformationPropertiesFormat(string changeNumber, string region, string systemService, IReadOnlyList<string> addressPrefixes, string state, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ChangeNumber = changeNumber;
            Region = region;
            SystemService = systemService;
            AddressPrefixes = addressPrefixes;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The iteration number of service tag. </summary>
        public string ChangeNumber { get; }
        /// <summary> The region of service tag. </summary>
        public string Region { get; }
        /// <summary> The name of system service. </summary>
        public string SystemService { get; }
        /// <summary> The list of IP address prefixes. </summary>
        public IReadOnlyList<string> AddressPrefixes { get; }
        /// <summary> The state of the service tag. </summary>
        public string State { get; }
    }
}
