// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The ServiceProviderProvisioningState state of the resource. </summary>
    public readonly partial struct ServiceProviderProvisioningState : IEquatable<ServiceProviderProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceProviderProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceProviderProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotProvisionedValue = "NotProvisioned";
        private const string ProvisioningValue = "Provisioning";
        private const string ProvisionedValue = "Provisioned";
        private const string DeprovisioningValue = "Deprovisioning";

        /// <summary> NotProvisioned. </summary>
        public static ServiceProviderProvisioningState NotProvisioned { get; } = new ServiceProviderProvisioningState(NotProvisionedValue);
        /// <summary> Provisioning. </summary>
        public static ServiceProviderProvisioningState Provisioning { get; } = new ServiceProviderProvisioningState(ProvisioningValue);
        /// <summary> Provisioned. </summary>
        public static ServiceProviderProvisioningState Provisioned { get; } = new ServiceProviderProvisioningState(ProvisionedValue);
        /// <summary> Deprovisioning. </summary>
        public static ServiceProviderProvisioningState Deprovisioning { get; } = new ServiceProviderProvisioningState(DeprovisioningValue);
        /// <summary> Determines if two <see cref="ServiceProviderProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ServiceProviderProvisioningState left, ServiceProviderProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceProviderProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ServiceProviderProvisioningState left, ServiceProviderProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceProviderProvisioningState"/>. </summary>
        public static implicit operator ServiceProviderProvisioningState(string value) => new ServiceProviderProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceProviderProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceProviderProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
